/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@InterfaceAudience.Private
@Metrics(about="HttpFSServer metrics", context="httpfs")
public class HttpFSServerMetrics {
    @Metric
    private MutableCounterLong bytesWritten;
    @Metric
    private MutableCounterLong bytesRead;
    @Metric
    private MutableCounterLong opsCreate;
    @Metric
    private MutableCounterLong opsAppend;
    @Metric
    private MutableCounterLong opsTruncate;
    @Metric
    private MutableCounterLong opsDelete;
    @Metric
    private MutableCounterLong opsRename;
    @Metric
    private MutableCounterLong opsMkdir;
    @Metric
    private MutableCounterLong opsOpen;
    @Metric
    private MutableCounterLong opsListing;
    @Metric
    private MutableCounterLong opsStat;
    @Metric
    private MutableCounterLong opsCheckAccess;
    @Metric
    private MutableCounterLong opsStatus;
    @Metric
    private MutableCounterLong opsAllECPolicies;
    @Metric
    private MutableCounterLong opsECCodecs;
    @Metric
    private MutableCounterLong opsTrashRoots;
    private final MetricsRegistry registry = new MetricsRegistry("httpfsserver");
    private final String name;
    private JvmMetrics jvmMetrics = null;

    public HttpFSServerMetrics(String name, String sessionId, JvmMetrics jvmMetrics) {
        this.name = name;
        this.jvmMetrics = jvmMetrics;
        this.registry.tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static HttpFSServerMetrics create(Configuration conf, String serverName) {
        String sessionId = conf.get("dfs.metrics.session-id");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)"HttpFSServer", (String)sessionId, (MetricsSystem)ms);
        String name = "ServerActivity-" + (String)(serverName.isEmpty() ? "UndefinedServer" + ThreadLocalRandom.current().nextInt() : serverName.replace(':', '-'));
        return (HttpFSServerMetrics)ms.register(name, null, (Object)new HttpFSServerMetrics(name, sessionId, jm));
    }

    public String name() {
        return this.name;
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void incrBytesWritten(long bytes) {
        this.bytesWritten.incr(bytes);
    }

    public void incrBytesRead(long bytes) {
        this.bytesRead.incr(bytes);
    }

    public void incrOpsCreate() {
        this.opsCreate.incr();
    }

    public void incrOpsAppend() {
        this.opsAppend.incr();
    }

    public void incrOpsTruncate() {
        this.opsTruncate.incr();
    }

    public void incrOpsDelete() {
        this.opsDelete.incr();
    }

    public void incrOpsRename() {
        this.opsRename.incr();
    }

    public void incrOpsMkdir() {
        this.opsMkdir.incr();
    }

    public void incrOpsOpen() {
        this.opsOpen.incr();
    }

    public void incrOpsListing() {
        this.opsListing.incr();
    }

    public void incrOpsStat() {
        this.opsStat.incr();
    }

    public void incrOpsCheckAccess() {
        this.opsCheckAccess.incr();
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public long getOpsMkdir() {
        return this.opsMkdir.value();
    }

    public long getOpsListing() {
        return this.opsListing.value();
    }

    public long getOpsStat() {
        return this.opsStat.value();
    }

    public void incrOpsStatus() {
        this.opsStatus.incr();
    }

    public void incrOpsAllECPolicies() {
        this.opsAllECPolicies.incr();
    }

    public void incrOpsECCodecs() {
        this.opsECCodecs.incr();
    }

    public void incrOpsTrashRoots() {
        this.opsTrashRoots.incr();
    }
}

