/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.client.HttpFSUtils;
import org.apache.hadoop.fs.http.server.FSOperations;
import org.apache.hadoop.fs.http.server.HttpFSParametersProvider;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.servlet.FileSystemReleaseFilter;
import org.apache.hadoop.lib.wsrs.InputStreamEntity;
import org.apache.hadoop.lib.wsrs.Parameters;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Path(value="/v1")
@InterfaceAudience.Private
public class HttpFSServer {
    private static Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSServer.class);
    AccessMode accessMode = AccessMode.READWRITE;

    public HttpFSServer() {
        Configuration conf = HttpFSServerWebApp.get().getConfig();
        String accessModeString = conf.get("httpfs.access.mode", "read-write").toLowerCase();
        this.accessMode = accessModeString.compareTo("write-only") == 0 ? AccessMode.WRITEONLY : (accessModeString.compareTo("read-only") == 0 ? AccessMode.READONLY : AccessMode.READWRITE);
    }

    private UserGroupInformation getHttpUGI(HttpServletRequest request) {
        UserGroupInformation user = HttpUserGroupInformation.get();
        if (user != null) {
            return user;
        }
        return UserGroupInformation.createRemoteUser((String)request.getUserPrincipal().getName());
    }

    private <T> T fsExecute(UserGroupInformation ugi, FileSystemAccess.FileSystemExecutor<T> executor) throws IOException, FileSystemAccessException {
        FileSystemAccess fsAccess = HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration();
        return fsAccess.execute(ugi.getShortUserName(), conf, executor);
    }

    private FileSystem createFileSystem(UserGroupInformation ugi) throws IOException, FileSystemAccessException {
        String hadoopUser = ugi.getShortUserName();
        FileSystemAccess fsAccess = HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration();
        FileSystem fs = fsAccess.createFileSystem(hadoopUser, conf);
        FileSystemReleaseFilter.setFileSystem(fs);
        return fs;
    }

    private void enforceRootPath(HttpFSFileSystem.Operation op, String path) {
        if (!path.equals("/")) {
            throw new UnsupportedOperationException(MessageFormat.format("Operation [{0}], invalid path [{1}], must be '/'", new Object[]{op, path}));
        }
    }

    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public Response getRoot(@Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.get("", uriInfo, op, params, request);
    }

    private String makeAbsolute(String path) {
        return "/" + (path != null ? path : "");
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response get(@PathParam(value="path") String path, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        if (op.value() != HttpFSFileSystem.Operation.GETFILESTATUS && op.value() != HttpFSFileSystem.Operation.LISTSTATUS && this.accessMode == AccessMode.WRITEONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        return switch ((HttpFSFileSystem.Operation)((Object)op.value())) {
            case HttpFSFileSystem.Operation.OPEN -> {
                Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
                if (noRedirect.booleanValue()) {
                    URI redirectURL = this.createOpenRedirectionURL(uriInfo);
                    String js = JsonUtil.toJsonString((String)"Location", (Object)redirectURL);
                    yield Response.ok((Object)js).type("application/json").build();
                }
                final FSOperations.FSOpen command = new FSOperations.FSOpen(path);
                final FileSystem fs = this.createFileSystem(user);
                InputStream is = null;
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user.getShortUserName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
                try {
                    is = (InputStream)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            return command.execute(fs);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    LOG.warn("Open interrupted.", (Throwable)ie);
                    Thread.currentThread().interrupt();
                }
                Long offset = (Long)params.get("offset", HttpFSParametersProvider.OffsetParam.class);
                Long len = (Long)params.get("length", HttpFSParametersProvider.LenParam.class);
                AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offset, len});
                InputStreamEntity entity = new InputStreamEntity(is, offset, len);
                yield Response.ok((Object)entity).type("application/octet-stream").build();
            }
            case HttpFSFileSystem.Operation.GETFILESTATUS -> {
                FSOperations.FSFileStatus command = new FSOperations.FSFileStatus(path);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.LISTSTATUS -> {
                String filter = (String)params.get("filter", HttpFSParametersProvider.FilterParam.class);
                FSOperations.FSListStatus command = new FSOperations.FSListStatus(path, filter);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] filter [{}]", (Object)path, (Object)(filter != null ? filter : "-"));
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETHOMEDIRECTORY -> {
                this.enforceRootPath((HttpFSFileSystem.Operation)((Object)op.value()), path);
                FSOperations.FSHomeDir command = new FSOperations.FSHomeDir();
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("Home Directory for [{}]", (Object)user);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.INSTRUMENTATION -> {
                this.enforceRootPath((HttpFSFileSystem.Operation)((Object)op.value()), path);
                Groups groups = HttpFSServerWebApp.get().get(Groups.class);
                Set<String> userGroups = groups.getGroupsSet(user.getShortUserName());
                if (!userGroups.contains(HttpFSServerWebApp.get().getAdminGroup())) {
                    throw new AccessControlException("User not in HttpFSServer admin group");
                }
                Instrumentation instrumentation = HttpFSServerWebApp.get().get(Instrumentation.class);
                Map<String, Map<String, ?>> snapshot = instrumentation.getSnapshot();
                yield Response.ok(snapshot).build();
            }
            case HttpFSFileSystem.Operation.GETCONTENTSUMMARY -> {
                FSOperations.FSContentSummary command = new FSOperations.FSContentSummary(path);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("Content summary for [{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETQUOTAUSAGE -> {
                FSOperations.FSQuotaUsage command = new FSOperations.FSQuotaUsage(path);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("Quota Usage for [{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETFILECHECKSUM -> {
                FSOperations.FSFileChecksum command = new FSOperations.FSFileChecksum(path);
                Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
                AUDIT_LOG.info("[{}]", (Object)path);
                if (noRedirect.booleanValue()) {
                    URI redirectURL = this.createOpenRedirectionURL(uriInfo);
                    String js = JsonUtil.toJsonString((String)"Location", (Object)redirectURL);
                    yield Response.ok((Object)js).type("application/json").build();
                }
                Map json = this.fsExecute(user, command);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETFILEBLOCKLOCATIONS -> {
                long offset = 0L;
                long len = Long.MAX_VALUE;
                Long offsetParam = (Long)params.get("offset", HttpFSParametersProvider.OffsetParam.class);
                Long lenParam = (Long)params.get("length", HttpFSParametersProvider.LenParam.class);
                AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offsetParam, lenParam});
                if (offsetParam != null && offsetParam > 0L) {
                    offset = offsetParam;
                }
                if (lenParam != null && lenParam > 0L) {
                    len = lenParam;
                }
                FSOperations.FSFileBlockLocations command = new FSOperations.FSFileBlockLocations(path, offset, len);
                Map locations = this.fsExecute(user, command);
                String json = JsonUtil.toJsonString((String)"BlockLocations", (Object)locations);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETACLSTATUS -> {
                FSOperations.FSAclStatus command = new FSOperations.FSAclStatus(path);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("ACL status for [{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETXATTRS -> {
                List<String> xattrNames = params.getValues("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
                XAttrCodec encoding = (XAttrCodec)params.get("encoding", HttpFSParametersProvider.XAttrEncodingParam.class);
                FSOperations.FSGetXAttrs command = new FSOperations.FSGetXAttrs(path, xattrNames, encoding);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("XAttrs for [{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.LISTXATTRS -> {
                FSOperations.FSListXAttrs command = new FSOperations.FSListXAttrs(path);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("XAttr names for [{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.LISTSTATUS_BATCH -> {
                String startAfter = (String)params.get("startAfter", HttpFSParametersProvider.StartAfterParam.class);
                byte[] token = HttpFSUtils.EMPTY_BYTES;
                if (startAfter != null) {
                    token = startAfter.getBytes(StandardCharsets.UTF_8);
                }
                FSOperations.FSListStatusBatch command = new FSOperations.FSListStatusBatch(path, token);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] token [{}]", (Object)path, (Object)token);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETTRASHROOT -> {
                FSOperations.FSTrashRoot command = new FSOperations.FSTrashRoot(path);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETALLSTORAGEPOLICY -> {
                FSOperations.FSGetAllStoragePolicies command = new FSOperations.FSGetAllStoragePolicies();
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSTORAGEPOLICY -> {
                FSOperations.FSGetStoragePolicy command = new FSOperations.FSGetStoragePolicy(path);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSNAPSHOTDIFF -> {
                String oldSnapshotName = (String)params.get("oldsnapshotname", HttpFSParametersProvider.OldSnapshotNameParam.class);
                String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
                FSOperations.FSGetSnapshotDiff command = new FSOperations.FSGetSnapshotDiff(path, oldSnapshotName, snapshotName);
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSNAPSHOTDIFFLISTING -> {
                String oldSnapshotName = (String)params.get("oldsnapshotname", HttpFSParametersProvider.OldSnapshotNameParam.class);
                String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
                String snapshotDiffStartPath = (String)params.get("snapshotdiffstartpath", HttpFSParametersProvider.SnapshotDiffStartPathParam.class);
                Integer snapshotDiffIndex = (Integer)params.get("snapshotdiffindex", HttpFSParametersProvider.SnapshotDiffIndexParam.class);
                FSOperations.FSGetSnapshotDiffListing command = new FSOperations.FSGetSnapshotDiffListing(path, oldSnapshotName, snapshotName, snapshotDiffStartPath, snapshotDiffIndex);
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSNAPSHOTTABLEDIRECTORYLIST -> {
                FSOperations.FSGetSnapshottableDirListing command = new FSOperations.FSGetSnapshottableDirListing();
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)"/");
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSNAPSHOTLIST -> {
                FSOperations.FSGetSnapshotListing command = new FSOperations.FSGetSnapshotListing(path);
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)"/");
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSERVERDEFAULTS -> {
                FSOperations.FSGetServerDefaults command = new FSOperations.FSGetServerDefaults();
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)"/");
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.CHECKACCESS -> {
                String mode = (String)params.get("fsaction", HttpFSParametersProvider.FsActionParam.class);
                HttpFSParametersProvider.FsActionParam fsparam = new HttpFSParametersProvider.FsActionParam(mode);
                FSOperations.FSAccess command = new FSOperations.FSAccess(path, FsAction.getFsAction((String)((String)fsparam.value())));
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)"/");
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.GETECPOLICY -> {
                FSOperations.FSGetErasureCodingPolicy command = new FSOperations.FSGetErasureCodingPolicy(path);
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETECPOLICIES -> {
                FSOperations.FSGetErasureCodingPolicies command = new FSOperations.FSGetErasureCodingPolicies();
                String js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETECCODECS -> {
                FSOperations.FSGetErasureCodingCodecs command = new FSOperations.FSGetErasureCodingCodecs();
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GET_BLOCK_LOCATIONS -> {
                long offset = 0L;
                long len = Long.MAX_VALUE;
                Long offsetParam = (Long)params.get("offset", HttpFSParametersProvider.OffsetParam.class);
                Long lenParam = (Long)params.get("length", HttpFSParametersProvider.LenParam.class);
                AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offsetParam, lenParam});
                if (offsetParam != null && offsetParam > 0L) {
                    offset = offsetParam;
                }
                if (lenParam != null && lenParam > 0L) {
                    len = lenParam;
                }
                FSOperations.FSFileBlockLocationsLegacy command = new FSOperations.FSFileBlockLocationsLegacy(path, offset, len);
                Map locations = this.fsExecute(user, command);
                String json = JsonUtil.toJsonString((String)"LocatedBlocks", (Object)locations);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETFILELINKSTATUS -> {
                FSOperations.FSFileLinkStatus command = new FSOperations.FSFileLinkStatus(path);
                Map js = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETSTATUS -> {
                FSOperations.FSStatus command = new FSOperations.FSStatus(path);
                Map js = this.fsExecute(user, command);
                yield Response.ok((Object)js).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.GETTRASHROOTS -> {
                Boolean allUsers = (Boolean)params.get("allusers", HttpFSParametersProvider.AllUsersParam.class);
                FSOperations.FSGetTrashRoots command = new FSOperations.FSGetTrashRoots(allUsers);
                Map json = this.fsExecute(user, command);
                AUDIT_LOG.info("allUsers [{}]", (Object)allUsers);
                yield Response.ok((Object)json).type("application/json").build();
            }
            default -> throw new IOException(MessageFormat.format("Invalid HTTP GET operation [{0}]", op.value()));
        };
    }

    private URI createOpenRedirectionURL(UriInfo uriInfo) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder.replaceQueryParam("noredirect", (Object[])null);
        return uriBuilder.build((Object[])null);
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response delete(@PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        return switch ((HttpFSFileSystem.Operation)((Object)op.value())) {
            case HttpFSFileSystem.Operation.DELETE -> {
                Boolean recursive = (Boolean)params.get("recursive", HttpFSParametersProvider.RecursiveParam.class);
                AUDIT_LOG.info("[{}] recursive [{}]", (Object)path, (Object)recursive);
                FSOperations.FSDelete command = new FSOperations.FSDelete(path, recursive);
                JSONObject json = this.fsExecute(user, command);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.DELETESNAPSHOT -> {
                String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
                FSOperations.FSDeleteSnapshot command = new FSOperations.FSDeleteSnapshot(path, snapshotName);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] deleted snapshot [{}]", (Object)path, (Object)snapshotName);
                yield Response.ok().build();
            }
            default -> throw new IOException(MessageFormat.format("Invalid HTTP DELETE operation [{0}]", op.value()));
        };
    }

    @POST
    @Produces(value={"application/json; charset=utf-8"})
    public Response postRoot(InputStream is, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.post(is, uriInfo, "/", op, params, request);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response post(InputStream is, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        return switch ((HttpFSFileSystem.Operation)((Object)op.value())) {
            case HttpFSFileSystem.Operation.APPEND -> {
                Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
                URI redirectURL = this.createUploadRedirectionURL(uriInfo, HttpFSFileSystem.Operation.APPEND);
                Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
                if (noRedirect.booleanValue()) {
                    String js = JsonUtil.toJsonString((String)"Location", (Object)redirectURL);
                    yield Response.ok((Object)js).type("application/json").build();
                }
                if (hasData.booleanValue()) {
                    FSOperations.FSAppend command = new FSOperations.FSAppend(is, path);
                    this.fsExecute(user, command);
                    AUDIT_LOG.info("[{}]", (Object)path);
                    yield Response.ok().type("application/json").build();
                }
                yield Response.temporaryRedirect((URI)redirectURL).build();
            }
            case HttpFSFileSystem.Operation.CONCAT -> {
                String sources = (String)params.get("sources", HttpFSParametersProvider.SourcesParam.class);
                FSOperations.FSConcat command = new FSOperations.FSConcat(path, sources.split(","));
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}]", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.TRUNCATE -> {
                Long newLength = (Long)params.get("newlength", HttpFSParametersProvider.NewLengthParam.class);
                FSOperations.FSTruncate command = new FSOperations.FSTruncate(path, newLength);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("Truncate [{}] to length [{}]", (Object)path, (Object)newLength);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.UNSETSTORAGEPOLICY -> {
                FSOperations.FSUnsetStoragePolicy command = new FSOperations.FSUnsetStoragePolicy(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("Unset storage policy [{}]", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.UNSETECPOLICY -> {
                FSOperations.FSUnSetErasureCodingPolicy command = new FSOperations.FSUnSetErasureCodingPolicy(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("Unset ec policy [{}]", (Object)path);
                yield Response.ok().build();
            }
            default -> throw new IOException(MessageFormat.format("Invalid HTTP POST operation [{0}]", op.value()));
        };
    }

    protected URI createUploadRedirectionURL(UriInfo uriInfo, Enum<?> uploadOperation) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder = uriBuilder.replaceQueryParam("op", new Object[]{uploadOperation}).queryParam("data", new Object[]{Boolean.TRUE}).replaceQueryParam("noredirect", (Object[])null);
        return uriBuilder.build(null);
    }

    @PUT
    @Produces(value={"application/json; charset=utf-8"})
    public Response putRoot(InputStream is, @Context UriInfo uriInfo, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        return this.put(is, uriInfo, "/", op, params, request);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response put(InputStream is, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params, @Context HttpServletRequest request) throws IOException, FileSystemAccessException {
        if (this.accessMode == AccessMode.READONLY) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserGroupInformation user = HttpUserGroupInformation.get();
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)((Object)op.value())).name());
        MDC.put((String)"hostname", (String)request.getRemoteAddr());
        return switch ((HttpFSFileSystem.Operation)((Object)op.value())) {
            case HttpFSFileSystem.Operation.CREATE -> {
                Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
                URI redirectURL = this.createUploadRedirectionURL(uriInfo, HttpFSFileSystem.Operation.CREATE);
                Boolean noRedirect = (Boolean)params.get("noredirect", HttpFSParametersProvider.NoRedirectParam.class);
                if (noRedirect.booleanValue()) {
                    String js = JsonUtil.toJsonString((String)"Location", (Object)redirectURL);
                    yield Response.ok((Object)js).type("application/json").build();
                }
                if (hasData.booleanValue()) {
                    Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                    Short unmaskedPermission = (Short)params.get("unmaskedpermission", HttpFSParametersProvider.UnmaskedPermissionParam.class);
                    Boolean override = (Boolean)params.get("overwrite", HttpFSParametersProvider.OverwriteParam.class);
                    Short replication = (Short)params.get("replication", HttpFSParametersProvider.ReplicationParam.class);
                    Long blockSize = (Long)params.get("blocksize", HttpFSParametersProvider.BlockSizeParam.class);
                    FSOperations.FSCreate command = new FSOperations.FSCreate(is, path, permission, override, replication, blockSize, unmaskedPermission);
                    this.fsExecute(user, command);
                    AUDIT_LOG.info("[{}] permission [{}] override [{}] replication [{}] blockSize [{}] unmaskedpermission [{}]", new Object[]{path, permission, override, replication, blockSize, unmaskedPermission});
                    String js = JsonUtil.toJsonString((String)"Location", (Object)uriInfo.getAbsolutePath());
                    yield Response.created((URI)uriInfo.getAbsolutePath()).type("application/json").entity((Object)js).build();
                }
                yield Response.temporaryRedirect((URI)redirectURL).build();
            }
            case HttpFSFileSystem.Operation.ALLOWSNAPSHOT -> {
                FSOperations.FSAllowSnapshot command = new FSOperations.FSAllowSnapshot(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] allowed snapshot", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.DISALLOWSNAPSHOT -> {
                FSOperations.FSDisallowSnapshot command = new FSOperations.FSDisallowSnapshot(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] disallowed snapshot", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.CREATESNAPSHOT -> {
                String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
                FSOperations.FSCreateSnapshot command = new FSOperations.FSCreateSnapshot(path, snapshotName);
                String json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] snapshot created as [{}]", (Object)path, (Object)snapshotName);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.SETXATTR -> {
                String xattrName = (String)params.get("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
                String xattrValue = (String)params.get("xattr.value", HttpFSParametersProvider.XAttrValueParam.class);
                EnumSet flag = (EnumSet)params.get("flag", HttpFSParametersProvider.XAttrSetFlagParam.class);
                FSOperations.FSSetXAttr command = new FSOperations.FSSetXAttr(path, xattrName, xattrValue, flag);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to xAttr [{}]", (Object)path, (Object)xattrName);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.RENAMESNAPSHOT -> {
                String oldSnapshotName = (String)params.get("oldsnapshotname", HttpFSParametersProvider.OldSnapshotNameParam.class);
                String snapshotName = (String)params.get("snapshotname", HttpFSParametersProvider.SnapshotNameParam.class);
                FSOperations.FSRenameSnapshot command = new FSOperations.FSRenameSnapshot(path, oldSnapshotName, snapshotName);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] renamed snapshot [{}] to [{}]", new Object[]{path, oldSnapshotName, snapshotName});
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.REMOVEXATTR -> {
                String xattrName = (String)params.get("xattr.name", HttpFSParametersProvider.XAttrNameParam.class);
                FSOperations.FSRemoveXAttr command = new FSOperations.FSRemoveXAttr(path, xattrName);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] removed xAttr [{}]", (Object)path, (Object)xattrName);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.MKDIRS -> {
                Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                Short unmaskedPermission = (Short)params.get("unmaskedpermission", HttpFSParametersProvider.UnmaskedPermissionParam.class);
                FSOperations.FSMkdirs command = new FSOperations.FSMkdirs(path, permission, unmaskedPermission);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] permission [{}] unmaskedpermission [{}]", new Object[]{path, permission, unmaskedPermission});
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.RENAME -> {
                String toPath = (String)params.get("destination", HttpFSParametersProvider.DestinationParam.class);
                FSOperations.FSRename command = new FSOperations.FSRename(path, toPath);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)toPath);
                yield Response.ok((Object)json).type("application/json").build();
            }
            case HttpFSFileSystem.Operation.SETOWNER -> {
                String owner = (String)params.get("owner", HttpFSParametersProvider.OwnerParam.class);
                String group = (String)params.get("group", HttpFSParametersProvider.GroupParam.class);
                FSOperations.FSSetOwner command = new FSOperations.FSSetOwner(path, owner, group);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to (O/G)[{}]", (Object)path, (Object)(owner + ":" + group));
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SETPERMISSION -> {
                Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                FSOperations.FSSetPermission command = new FSOperations.FSSetPermission(path, permission);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)permission);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SETREPLICATION -> {
                Short replication = (Short)params.get("replication", HttpFSParametersProvider.ReplicationParam.class);
                FSOperations.FSSetReplication command = new FSOperations.FSSetReplication(path, replication);
                JSONObject json = this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)replication);
                yield Response.ok((Object)json).build();
            }
            case HttpFSFileSystem.Operation.SETTIMES -> {
                Long modifiedTime = (Long)params.get("modificationtime", HttpFSParametersProvider.ModifiedTimeParam.class);
                Long accessTime = (Long)params.get("accesstime", HttpFSParametersProvider.AccessTimeParam.class);
                FSOperations.FSSetTimes command = new FSOperations.FSSetTimes(path, modifiedTime, accessTime);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to (M/A)[{}]", (Object)path, (Object)(modifiedTime + ":" + accessTime));
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SETACL -> {
                String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
                FSOperations.FSSetAcl command = new FSOperations.FSSetAcl(path, aclSpec);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to acl [{}]", (Object)path, (Object)aclSpec);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.REMOVEACL -> {
                FSOperations.FSRemoveAcl command = new FSOperations.FSRemoveAcl(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] removed acl", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.MODIFYACLENTRIES -> {
                String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
                FSOperations.FSModifyAclEntries command = new FSOperations.FSModifyAclEntries(path, aclSpec);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] modify acl entry with [{}]", (Object)path, (Object)aclSpec);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.REMOVEACLENTRIES -> {
                String aclSpec = (String)params.get("aclspec", HttpFSParametersProvider.AclPermissionParam.class);
                FSOperations.FSRemoveAclEntries command = new FSOperations.FSRemoveAclEntries(path, aclSpec);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] remove acl entry [{}]", (Object)path, (Object)aclSpec);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.REMOVEDEFAULTACL -> {
                FSOperations.FSRemoveDefaultAcl command = new FSOperations.FSRemoveDefaultAcl(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] remove default acl", (Object)path);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SETSTORAGEPOLICY -> {
                String policyName = (String)params.get("storagepolicy", HttpFSParametersProvider.PolicyNameParam.class);
                FSOperations.FSSetStoragePolicy command = new FSOperations.FSSetStoragePolicy(path, policyName);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to policy [{}]", (Object)path, (Object)policyName);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SETECPOLICY -> {
                String policyName = (String)params.get("ecpolicy", HttpFSParametersProvider.ECPolicyParam.class);
                FSOperations.FSSetErasureCodingPolicy command = new FSOperations.FSSetErasureCodingPolicy(path, policyName);
                this.fsExecute(user, command);
                AUDIT_LOG.info("[{}] to policy [{}]", (Object)path, (Object)policyName);
                yield Response.ok().build();
            }
            case HttpFSFileSystem.Operation.SATISFYSTORAGEPOLICY -> {
                FSOperations.FSSatisyStoragePolicy command = new FSOperations.FSSatisyStoragePolicy(path);
                this.fsExecute(user, command);
                AUDIT_LOG.info("satisfy storage policy for [{}]", (Object)path);
                yield Response.ok().build();
            }
            default -> throw new IOException(MessageFormat.format("Invalid HTTP PUT operation [{0}]", op.value()));
        };
    }

    static enum AccessMode {
        READWRITE,
        WRITEONLY,
        READONLY;

    }
}

