/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);

    public static boolean isHealthy(URI uri) {
        boolean bl;
        block11: {
            String scheme = uri.getScheme();
            if (!"hdfs".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException("The scheme is not hdfs, uri=" + uri);
            }
            Configuration conf = new Configuration();
            conf.setBoolean(String.format("fs.%s.impl.disable.cache", scheme), true);
            conf.setBoolean("dfs.client.retry.policy.enabled", false);
            conf.setInt("ipc.client.connect.max.retries", 0);
            DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            try {
                boolean safemode = fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Is namenode in safemode? {}; uri={}", (Object)safemode, (Object)uri);
                }
                boolean bl2 = bl = !safemode;
                if (fs == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Got an exception for uri={}", (Object)uri, (Object)e);
                    }
                    return false;
                }
            }
            fs.close();
        }
        return bl;
    }
}

