/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.ConfRefreshTokenBasedAccessTokenProvider;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RequestDefinition;

public class TestRefreshTokenTimeBasedTokenRefresher {
    public static final Header CONTENT_TYPE_APPLICATION_JSON = new Header("Content-Type", new String[]{"application/json"});

    public Configuration buildConf(String refreshToken, String tokenExpires, String clientId, String refreshURL) {
        Configuration conf = new Configuration();
        conf.set("dfs.webhdfs.oauth2.refresh.token", refreshToken);
        conf.set("dfs.webhdfs.oauth2.refresh.token.expires.ms.since.epoch", tokenExpires);
        conf.set("dfs.webhdfs.oauth2.client.id", clientId);
        conf.set("dfs.webhdfs.oauth2.refresh.url", refreshURL);
        return conf;
    }

    @Test
    public void refreshUrlIsCorrect() throws IOException {
        int PORT = 7552;
        String REFRESH_ADDRESS = "http://localhost:7552/refresh";
        long tokenExpires = 0L;
        Configuration conf = this.buildConf("refresh token key", Long.toString(tokenExpires), "joebob", "http://localhost:7552/refresh");
        Timer mockTimer = (Timer)Mockito.mock(Timer.class);
        Mockito.when((Object)mockTimer.now()).thenReturn((Object)(tokenExpires + 1000L));
        ConfRefreshTokenBasedAccessTokenProvider tokenProvider = new ConfRefreshTokenBasedAccessTokenProvider(mockTimer);
        tokenProvider.setConf(conf);
        ClientAndServer mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{7552});
        HttpRequest expectedRequest = HttpRequest.request().withMethod("POST").withPath("/refresh").withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"client_id", (String[])new String[]{"joebob"}), Parameter.param((String)"grant_type", (String[])new String[]{"refresh_token"}), Parameter.param((String)"refresh_token", (String[])new String[]{"refresh token key"})}));
        MockServerClient mockServerClient = new MockServerClient("localhost", 7552);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("expires_in", "0987654321");
        map.put("token_type", "bearer");
        map.put("access_token", "new access token");
        ObjectMapper mapper = new ObjectMapper();
        HttpResponse resp = HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeaders(new Header[]{CONTENT_TYPE_APPLICATION_JSON}).withBody(mapper.writeValueAsString(map));
        mockServerClient.when((RequestDefinition)expectedRequest, Times.exactly((int)1)).respond(resp);
        Assertions.assertEquals((Object)"new access token", (Object)tokenProvider.getAccessToken());
        mockServerClient.verify(new RequestDefinition[]{expectedRequest});
        mockServerClient.clear((RequestDefinition)expectedRequest);
        mockServer.stop();
    }
}

