/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestByteRangeInputStream {
    private ByteRangeInputStream.URLOpener getMockURLOpener(URL url) throws IOException {
        ByteRangeInputStream.URLOpener opener = (ByteRangeInputStream.URLOpener)Mockito.mock(ByteRangeInputStream.URLOpener.class, (Answer)Mockito.CALLS_REAL_METHODS);
        opener.setURL(url);
        ((ByteRangeInputStream.URLOpener)Mockito.doReturn((Object)this.getMockConnection("65535")).when((Object)opener)).connect(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        return opener;
    }

    private HttpURLConnection getMockConnection(String length) throws IOException {
        HttpURLConnection mockConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doReturn((Object)new ByteArrayInputStream("asdf".getBytes())).when((Object)mockConnection)).getInputStream();
        ((HttpURLConnection)Mockito.doReturn((Object)length).when((Object)mockConnection)).getHeaderField("Content-Length");
        return mockConnection;
    }

    @Test
    public void testByteRange() throws IOException {
        ByteRangeInputStream.URLOpener oMock = this.getMockURLOpener(new URL("http://test"));
        ByteRangeInputStream.URLOpener rMock = this.getMockURLOpener(null);
        ByteRangeInputStreamImpl bris = new ByteRangeInputStreamImpl(oMock, rMock);
        bris.seek(0L);
        Assertions.assertEquals((long)0L, (long)bris.getPos(), (String)"getPos wrong");
        bris.read();
        Assertions.assertEquals((long)0L, (long)bris.startPos, (String)"Initial call made incorrectly (offset check)");
        Assertions.assertEquals((long)1L, (long)bris.getPos(), (String)"getPos should return 1 after reading one byte");
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)oMock, (VerificationMode)Mockito.times((int)1))).connect(0L, false);
        bris.read();
        Assertions.assertEquals((long)2L, (long)bris.getPos(), (String)"getPos should return 2 after reading two bytes");
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)oMock, (VerificationMode)Mockito.times((int)1))).connect(0L, false);
        rMock.setURL(new URL("http://resolvedurl/"));
        bris.seek(100L);
        bris.read();
        Assertions.assertEquals((long)100L, (long)bris.startPos, (String)"Seek to 100 bytes made incorrectly (offset Check)");
        Assertions.assertEquals((long)101L, (long)bris.getPos(), (String)"getPos should return 101 after reading one byte");
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)1))).connect(100L, true);
        bris.seek(101L);
        bris.read();
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)1))).connect(100L, true);
        ((ByteRangeInputStream.URLOpener)Mockito.verify((Object)rMock, (VerificationMode)Mockito.times((int)0))).connect(101L, true);
        bris.seek(2500L);
        bris.read();
        Assertions.assertEquals((long)2500L, (long)bris.startPos, (String)"Seek to 2500 bytes made incorrectly (offset Check)");
        ((ByteRangeInputStream.URLOpener)Mockito.doReturn((Object)this.getMockConnection(null)).when((Object)rMock)).connect(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        bris.seek(500L);
        try {
            bris.read();
            Assertions.fail((String)"Exception should be thrown when content-length is not given");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Content-Length is missing: "), (String)("Incorrect response message: " + e.getMessage()));
        }
        bris.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropagatedClose() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(Long.valueOf(1L), (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        int brisOpens = 0;
        int brisCloses = 0;
        int isCloses = 0;
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.seek(1L);
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.seek(1L);
        bris.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        bris.close();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        bris.close();
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
        boolean errored = false;
        try {
            bris.getInputStream();
        }
        catch (IOException e) {
            errored = true;
            Assertions.assertEquals((Object)"Stream closed", (Object)e.getMessage());
        }
        finally {
            Assertions.assertTrue((boolean)errored, (String)"Read a closed steam");
        }
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream(Mockito.anyLong());
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream.in, (VerificationMode)Mockito.times((int)isCloses))).close();
    }

    @Test
    public void testAvailable() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(Long.valueOf(65535L), (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        Assertions.assertEquals((int)65535, (int)bris.available(), (String)"Before read or seek, available should be same as filelength");
        ((ByteRangeInputStream)Mockito.verify((Object)bris, (VerificationMode)Mockito.times((int)1))).openInputStream(Mockito.anyLong());
        bris.seek(10L);
        Assertions.assertEquals((int)65525, (int)bris.available(), (String)"Seek 10 bytes, available should return filelength - 10");
        bris.seek(65535L);
        Assertions.assertEquals((int)0, (int)bris.available(), (String)"Seek till end of file, available should return 0 bytes");
        bris.seek(0L);
        bris.read();
        Assertions.assertEquals((int)65534, (int)bris.available(), (String)"Read 1 byte, available must return  filelength - 1");
        bris.read();
        Assertions.assertEquals((int)65533, (int)bris.available(), (String)"Read another 1 byte, available must return  filelength - 2");
        bris.seek(100L);
        bris.read();
        Assertions.assertEquals((int)65434, (int)bris.available(), (String)"Seek to offset 100 and read 1 byte, available should return filelength - 101");
        bris.close();
    }

    @Test
    public void testAvailableLengthNotKnown() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(null, (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)bris.available());
    }

    @Test
    public void testAvailableStreamClosed() throws IOException {
        ByteRangeInputStream bris = (ByteRangeInputStream)Mockito.mock(ByteRangeInputStream.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ByteRangeInputStream.InputStreamAndFileLength mockStream = new ByteRangeInputStream.InputStreamAndFileLength(null, (InputStream)Mockito.mock(InputStream.class));
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)bris)).openInputStream(Mockito.anyLong());
        Whitebox.setInternalState((Object)bris, (String)"status", (Object)ByteRangeInputStream.StreamStatus.SEEK);
        bris.close();
        try {
            bris.available();
            Assertions.fail((String)"Exception should be thrown when stream is closed");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("Stream closed"), (String)"Exception when stream is closed");
        }
    }

    private class ByteRangeInputStreamImpl
    extends ByteRangeInputStream {
        public ByteRangeInputStreamImpl(ByteRangeInputStream.URLOpener o, ByteRangeInputStream.URLOpener r) throws IOException {
            super(o, r);
        }

        protected URL getResolvedUrl(HttpURLConnection connection) throws IOException {
            return new URL("http://resolvedurl/");
        }
    }
}

