/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.util.ECPolicyLoader;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestECPolicyLoader {
    private static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static final String POLICY_FILE = new File(TEST_DIR, "test-ecpolicy").getAbsolutePath();

    @Test
    public void testLoadECPolicy() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>1</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>rs</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>rs-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>131072</cellsize>");
        out.println("  </policy>");
        out.println("  <policy>");
        out.println("    <schema>RS-legacyk12m4</schema>");
        out.println("    <cellsize>262144</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        List policies = ecPolicyLoader.loadPolicy(POLICY_FILE);
        Assertions.assertEquals((int)2, (int)policies.size());
        ErasureCodingPolicy policy1 = (ErasureCodingPolicy)policies.get(0);
        ECSchema schema1 = policy1.getSchema();
        Assertions.assertEquals((int)131072, (int)policy1.getCellSize());
        Assertions.assertEquals((int)0, (int)schema1.getExtraOptions().size());
        Assertions.assertEquals((int)12, (int)schema1.getNumDataUnits());
        Assertions.assertEquals((int)4, (int)schema1.getNumParityUnits());
        Assertions.assertEquals((Object)"rs", (Object)schema1.getCodecName());
        ErasureCodingPolicy policy2 = (ErasureCodingPolicy)policies.get(1);
        ECSchema schema2 = policy2.getSchema();
        Assertions.assertEquals((int)262144, (int)policy2.getCellSize());
        Assertions.assertEquals((int)0, (int)schema2.getExtraOptions().size());
        Assertions.assertEquals((int)12, (int)schema2.getNumDataUnits());
        Assertions.assertEquals((int)4, (int)schema2.getNumParityUnits());
        Assertions.assertEquals((Object)"rs-legacy", (Object)schema2.getCodecName());
    }

    @Test
    public void testNullECSchemaOptionValue() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>1</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>RS</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("    <option></option>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RS-legacyk12m4</schema>");
        out.println("    <cellsize>1024</cellsize>");
        out.println("  </policy>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>20480</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        try {
            ecPolicyLoader.loadPolicy(POLICY_FILE);
            Assertions.fail((String)"IllegalArgumentException should be thrown for null value");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Value of <option> is null", (Throwable)e);
        }
    }

    @Test
    public void testRepeatECSchema() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>1</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RS-legacyk12m4</schema>");
        out.println("    <cellsize>1024</cellsize>");
        out.println("  </policy>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>20480</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        try {
            ecPolicyLoader.loadPolicy(POLICY_FILE);
            Assertions.fail((String)"RuntimeException should be thrown for repetitive elements");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Repetitive schemas in EC policy configuration file: RS-legacyk12m4", (Throwable)e);
        }
    }

    @Test
    public void testBadECLayoutVersion() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>3</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>RS</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>1024</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        try {
            ecPolicyLoader.loadPolicy(POLICY_FILE);
            Assertions.fail((String)"RuntimeException should be thrown for bad layoutversion");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"The parse failed because of bad layoutversion value", (Throwable)e);
        }
    }

    @Test
    public void testBadECCellsize() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>1</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>RS</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>free</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        try {
            ecPolicyLoader.loadPolicy(POLICY_FILE);
            Assertions.fail((String)"IllegalArgumentException should be thrown for bad policy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Bad EC policy cellsize value free is found. It should be an integer", (Throwable)e);
        }
    }

    @Test
    public void testBadECPolicy() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(POLICY_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<configuration>");
        out.println("<layoutversion>1</layoutversion>");
        out.println("<schemas>");
        out.println("  <schema id=\"RSk12m4\">");
        out.println("    <codec>RS</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("  <schema id=\"RS-legacyk12m4\">");
        out.println("    <codec>RS-legacy</codec>");
        out.println("    <k>12</k>");
        out.println("    <m>4</m>");
        out.println("  </schema>");
        out.println("</schemas>");
        out.println("<policies>");
        out.println("  <policy>");
        out.println("    <schema>RSk12m4</schema>");
        out.println("    <cellsize>-1025</cellsize>");
        out.println("  </policy>");
        out.println("</policies>");
        out.println("</configuration>");
        out.close();
        ECPolicyLoader ecPolicyLoader = new ECPolicyLoader();
        try {
            ecPolicyLoader.loadPolicy(POLICY_FILE);
            Assertions.fail((String)"RuntimeException should be thrown for bad policy");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Bad policy is found in EC policy configuration file", (Throwable)e);
        }
    }
}

