/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.RequestHedgingProxyProvider;
import org.apache.hadoop.net.MockDomainNameResolver;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestConfiguredFailoverProxyProvider {
    private Configuration conf;
    private int rpcPort = 8020;
    private URI ns1Uri;
    private URI ns2Uri;
    private URI ns3Uri;
    private URI ns4Uri;
    private String ns1;
    private String ns1nn1Hostname = "machine1.foo.bar";
    private InetSocketAddress ns1nn1 = new InetSocketAddress(this.ns1nn1Hostname, this.rpcPort);
    private String ns1nn2Hostname = "machine2.foo.bar";
    private InetSocketAddress ns1nn2 = new InetSocketAddress(this.ns1nn2Hostname, this.rpcPort);
    private String ns2;
    private String ns2nn1Hostname = "router1.foo.bar";
    private InetSocketAddress ns2nn1 = new InetSocketAddress(this.ns2nn1Hostname, this.rpcPort);
    private String ns2nn2Hostname = "router2.foo.bar";
    private InetSocketAddress ns2nn2 = new InetSocketAddress(this.ns2nn2Hostname, this.rpcPort);
    private String ns2nn3Hostname = "router3.foo.bar";
    private InetSocketAddress ns2nn3 = new InetSocketAddress(this.ns2nn3Hostname, this.rpcPort);
    private String ns3;
    private static final int NUM_ITERATIONS = 50;
    private String ns4;
    private String ns4nn1Hostname = "localhost";
    private String ns4nn2Hostname = "127.0.0.1";

    @BeforeAll
    public static void setupClass() throws Exception {
        GenericTestUtils.setLogLevel((Logger)RequestHedgingProxyProvider.LOG, (Level)Level.TRACE);
    }

    @BeforeEach
    public void setup() throws URISyntaxException {
        this.ns1 = "mycluster-1-" + Time.monotonicNow();
        this.ns1Uri = new URI("hdfs://" + this.ns1);
        this.conf = new Configuration();
        this.conf.set("dfs.ha.namenodes." + this.ns1, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns1 + ".nn1", this.ns1nn1Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns1 + ".nn2", this.ns1nn2Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.client.failover.proxy.provider." + this.ns1, ConfiguredFailoverProxyProvider.class.getName());
        this.conf.setBoolean("dfs.client.failover.random.order." + this.ns1, false);
        this.ns2 = "myroutercluster-2-" + Time.monotonicNow();
        this.ns2Uri = new URI("hdfs://" + this.ns2);
        this.conf.set("dfs.ha.namenodes." + this.ns2, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn1", this.ns2nn1Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn2", this.ns2nn2Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn3", this.ns2nn3Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.client.failover.proxy.provider." + this.ns2, ConfiguredFailoverProxyProvider.class.getName());
        this.conf.setBoolean("dfs.client.failover.random.order." + this.ns2, true);
        this.ns3 = "mycluster-3-" + Time.monotonicNow();
        this.ns3Uri = new URI("hdfs://" + this.ns3);
        this.ns4 = "mycluster-4-" + Time.monotonicNow();
        this.ns4Uri = new URI("hdfs://" + this.ns4);
        this.conf.set("dfs.nameservices", String.join((CharSequence)",", this.ns1, this.ns2, this.ns3, this.ns4));
        this.conf.set("fs.defaultFS", "hdfs://" + this.ns1);
    }

    private void addDNSSettings(Configuration config, boolean hostResolvable, boolean useFQDN) {
        config.set("dfs.ha.namenodes." + this.ns3, "nn");
        String domain = hostResolvable ? "test.foo.bar" : "unknown.foo.bar";
        config.set("dfs.namenode.rpc-address." + this.ns3 + ".nn", domain + ":" + this.rpcPort);
        config.set("dfs.client.failover.proxy.provider." + this.ns3, ConfiguredFailoverProxyProvider.class.getName());
        config.setBoolean("dfs.client.failover.resolve-needed." + this.ns3, true);
        config.set("dfs.client.failover.resolver.impl." + this.ns3, MockDomainNameResolver.class.getName());
        config.setBoolean("dfs.client.failover.random.order." + this.ns3, true);
        config.setBoolean("dfs.client.failover.resolver.useFQDN." + this.ns3, useFQDN);
    }

    private void addLazyResolvedSettings(Configuration config, boolean isLazy) {
        config.set("dfs.ha.namenodes." + this.ns4, "nn1,nn2,nn3");
        config.set("dfs.namenode.rpc-address." + this.ns4 + ".nn1", this.ns4nn1Hostname + ":" + this.rpcPort);
        config.set("dfs.namenode.rpc-address." + this.ns4 + ".nn2", this.ns4nn2Hostname + ":" + this.rpcPort);
        config.set("dfs.client.failover.proxy.provider." + this.ns4, ConfiguredFailoverProxyProvider.class.getName());
        if (isLazy) {
            config.setBoolean("dfs.client.failover.lazy.resolved", true);
        }
        config.setBoolean("dfs.client.failover.random.order." + this.ns4, false);
    }

    @Test
    public void testNonRandomGetProxy() throws Exception {
        AtomicInteger nn1Count = new AtomicInteger(0);
        AtomicInteger nn2Count = new AtomicInteger(0);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        ClientProtocol nn1Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenAnswer(this.createAnswer(nn1Count, 1L));
        proxyMap.put(this.ns1nn1, nn1Mock);
        ClientProtocol nn2Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn2Mock.getStats()).thenAnswer(this.createAnswer(nn2Count, 2L));
        proxyMap.put(this.ns1nn2, nn2Mock);
        ConfiguredFailoverProxyProvider provider1 = new ConfiguredFailoverProxyProvider(this.conf, this.ns1Uri, ClientProtocol.class, this.createFactory(proxyMap));
        ClientProtocol proxy1 = (ClientProtocol)provider1.getProxy().proxy;
        proxy1.getStats();
        Assertions.assertEquals((int)1, (int)nn1Count.get());
        Assertions.assertEquals((int)0, (int)nn2Count.get());
        proxy1.getStats();
        Assertions.assertEquals((int)2, (int)nn1Count.get());
        Assertions.assertEquals((int)0, (int)nn2Count.get());
        nn1Count.set(0);
        nn2Count.set(0);
        for (int i = 0; i < 50; ++i) {
            ConfiguredFailoverProxyProvider provider2 = new ConfiguredFailoverProxyProvider(this.conf, this.ns1Uri, ClientProtocol.class, this.createFactory(proxyMap));
            ClientProtocol proxy2 = (ClientProtocol)provider2.getProxy().proxy;
            proxy2.getStats();
        }
        Assertions.assertEquals((int)50, (int)nn1Count.get());
        Assertions.assertEquals((int)0, (int)nn2Count.get());
    }

    @Test
    public void testRandomGetProxy() throws Exception {
        AtomicInteger nn1Count = new AtomicInteger(0);
        AtomicInteger nn2Count = new AtomicInteger(0);
        AtomicInteger nn3Count = new AtomicInteger(0);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        ClientProtocol nn1Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenAnswer(this.createAnswer(nn1Count, 1L));
        proxyMap.put(this.ns2nn1, nn1Mock);
        ClientProtocol nn2Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn2Mock.getStats()).thenAnswer(this.createAnswer(nn2Count, 2L));
        proxyMap.put(this.ns2nn2, nn2Mock);
        ClientProtocol nn3Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn3Mock.getStats()).thenAnswer(this.createAnswer(nn3Count, 3L));
        proxyMap.put(this.ns2nn3, nn3Mock);
        for (int i = 0; i < 50; ++i) {
            ConfiguredFailoverProxyProvider provider = new ConfiguredFailoverProxyProvider(this.conf, this.ns2Uri, ClientProtocol.class, this.createFactory(proxyMap));
            ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
            proxy.getStats();
        }
        Assertions.assertTrue((nn1Count.get() < 50 && nn1Count.get() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((nn2Count.get() < 50 && nn2Count.get() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((nn3Count.get() < 50 && nn3Count.get() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)50, (int)(nn1Count.get() + nn2Count.get() + nn3Count.get()));
    }

    private void testResolveDomainNameUsingDNS(boolean useFQDN) throws Exception {
        Configuration dnsConf = new Configuration(this.conf);
        this.addDNSSettings(dnsConf, true, useFQDN);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        AtomicInteger nn1Count = this.addClientMock(useFQDN ? "host01.test" : "10.1.1.1", proxyMap);
        AtomicInteger nn2Count = this.addClientMock(useFQDN ? "host02.test" : "10.1.1.2", proxyMap);
        HashMap<String, AtomicInteger> proxyResults = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < 50; ++i) {
            ConfiguredFailoverProxyProvider provider = new ConfiguredFailoverProxyProvider(dnsConf, this.ns3Uri, ClientProtocol.class, this.createFactory(proxyMap));
            ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
            String proxyAddress = provider.getProxy().proxyInfo;
            if (proxyResults.containsKey(proxyAddress)) {
                ((AtomicInteger)proxyResults.get(proxyAddress)).incrementAndGet();
            } else {
                proxyResults.put(proxyAddress, new AtomicInteger(1));
            }
            proxy.getStats();
        }
        String resolvedHost1 = useFQDN ? "host01.test" : "/10.1.1.1";
        String resolvedHost2 = useFQDN ? "host02.test" : "/10.1.1.2";
        Assertions.assertEquals((int)2, (int)proxyResults.size());
        if (Shell.isJavaVersionAtLeast((int)14) && useFQDN) {
            Assertions.assertTrue((boolean)proxyResults.containsKey(resolvedHost1 + "/<unresolved>:8020"), (String)("nn1 wasn't returned: " + proxyResults));
            Assertions.assertTrue((boolean)proxyResults.containsKey(resolvedHost2 + "/<unresolved>:8020"), (String)("nn2 wasn't returned: " + proxyResults));
        } else {
            Assertions.assertTrue((boolean)proxyResults.containsKey(resolvedHost1 + ":8020"), (String)("nn1 wasn't returned: " + proxyResults));
            Assertions.assertTrue((boolean)proxyResults.containsKey(resolvedHost2 + ":8020"), (String)("nn2 wasn't returned: " + proxyResults));
        }
        Assertions.assertEquals((int)50, (int)(nn1Count.get() + nn2Count.get()));
        Assertions.assertTrue((nn1Count.get() < 50 ? 1 : 0) != 0, (String)("nn1 was selected too much:" + nn1Count.get()));
        Assertions.assertTrue((nn1Count.get() > 0 ? 1 : 0) != 0, (String)("nn1 should have been selected: " + nn1Count.get()));
        Assertions.assertTrue((nn2Count.get() < 50 ? 1 : 0) != 0, (String)("nn2 was selected too much:" + nn2Count.get()));
        Assertions.assertTrue((nn2Count.get() > 0 ? 1 : 0) != 0, (String)("nn2 should have been selected: " + nn2Count.get()));
    }

    @Test
    public void testResolveDomainNameUsingDNS() throws Exception {
        this.testResolveDomainNameUsingDNS(false);
        this.testResolveDomainNameUsingDNS(true);
    }

    @Test
    public void testLazyResolved() throws IOException {
        this.testLazyResolved(false);
        this.testLazyResolved(true);
    }

    private void testLazyResolved(boolean isLazy) throws IOException {
        Configuration lazyResolvedConf = new Configuration(this.conf);
        this.addLazyResolvedSettings(lazyResolvedConf, isLazy);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        InetSocketAddress ns4nn1 = new InetSocketAddress(this.ns4nn1Hostname, this.rpcPort);
        InetSocketAddress ns4nn2 = new InetSocketAddress(this.ns4nn2Hostname, this.rpcPort);
        ClientProtocol nn1Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenReturn((Object)new long[]{0L});
        proxyMap.put(ns4nn1, nn1Mock);
        ClientProtocol nn2Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenReturn((Object)new long[]{0L});
        proxyMap.put(ns4nn2, nn2Mock);
        ConfiguredFailoverProxyProvider provider = new ConfiguredFailoverProxyProvider(lazyResolvedConf, this.ns4Uri, ClientProtocol.class, this.createFactory(proxyMap));
        Assertions.assertEquals((int)2, (int)provider.proxies.size());
        for (AbstractNNFailoverProxyProvider.NNProxyInfo proxyInfo : provider.proxies) {
            if (isLazy) {
                Assertions.assertTrue((boolean)proxyInfo.getAddress().isUnresolved());
                continue;
            }
            Assertions.assertFalse((boolean)proxyInfo.getAddress().isUnresolved());
        }
        ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
        proxy.getStats();
        Assertions.assertFalse((boolean)((AbstractNNFailoverProxyProvider.NNProxyInfo)provider.proxies.get(0)).getAddress().isUnresolved());
    }

    @Test
    public void testResolveDomainNameUsingDNSUnknownHost() throws Exception {
        Configuration dnsConf = new Configuration(this.conf);
        this.addDNSSettings(dnsConf, false, false);
        HashMap proxyMap = new HashMap();
        Assertions.assertThrows(RuntimeException.class, () -> {
            ConfiguredFailoverProxyProvider provider = new ConfiguredFailoverProxyProvider(dnsConf, this.ns3Uri, ClientProtocol.class, this.createFactory(proxyMap));
            Assertions.assertNull((Object)provider, (String)"failover proxy cannot be created due to unknownhost");
        });
    }

    private AtomicInteger addClientMock(String host, Map<InetSocketAddress, ClientProtocol> proxyMap) throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        InetSocketAddress inetSockerAddr = new InetSocketAddress(host, this.rpcPort);
        ClientProtocol cpMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)cpMock.getStats()).thenAnswer(this.createAnswer(counter, 1L));
        proxyMap.put(inetSockerAddr, cpMock);
        return counter;
    }

    private Answer<long[]> createAnswer(final AtomicInteger counter, final long retVal) {
        return new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                return new long[]{retVal};
            }
        };
    }

    private HAProxyFactory<ClientProtocol> createFactory(Map<InetSocketAddress, ClientProtocol> proxies) {
        final Map<InetSocketAddress, ClientProtocol> proxyMap = proxies;
        return new HAProxyFactory<ClientProtocol>(){

            public ClientProtocol createProxy(Configuration cfg, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
                if (proxyMap.containsKey(nnAddr)) {
                    return (ClientProtocol)proxyMap.get(nnAddr);
                }
                throw new IOException("Name node address not found");
            }

            public ClientProtocol createProxy(Configuration cfg, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
                if (proxyMap.containsKey(nnAddr)) {
                    return (ClientProtocol)proxyMap.get(nnAddr);
                }
                throw new IOException("Name node address not found");
            }
        };
    }
}

