/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReadOnly {
    private static final Method[] ALL_METHODS = ClientProtocol.class.getMethods();
    private static final Set<String> READONLY_METHOD_NAMES = new HashSet<String>(Arrays.asList("getBlockLocations", "getServerDefaults", "getStoragePolicies", "getStoragePolicy", "getListing", "getBatchedListing", "getSnapshottableDirListing", "getSnapshotListing", "getPreferredBlockSize", "listCorruptFileBlocks", "getFileInfo", "isFileClosed", "getFileLinkInfo", "getLocatedFileInfo", "getContentSummary", "getLinkTarget", "getSnapshotDiffReport", "getSnapshotDiffReportListing", "listCacheDirectives", "listCachePools", "getAclStatus", "getEZForPath", "getEnclosingRoot", "listEncryptionZones", "listReencryptionStatus", "getXAttrs", "listXAttrs", "checkAccess", "getErasureCodingPolicies", "getErasureCodingCodecs", "getErasureCodingPolicy", "listOpenFiles", "getStats", "getReplicatedBlockStats", "getECBlockGroupStats", "getDatanodeReport", "getDatanodeStorageReport", "getDataEncryptionKey", "getCurrentEditLogTxid", "getEditsFromTxid", "getQuotaUsage", "msync", "getHAServiceState", "getECTopologyResultForPolicies", "getSlowDatanodeReport"));

    @Test
    public void testReadOnly() {
        for (Method m : ALL_METHODS) {
            boolean expected = READONLY_METHOD_NAMES.contains(m.getName());
            this.checkIsReadOnly(m.getName(), expected);
        }
    }

    private void checkIsReadOnly(String methodName, boolean expected) {
        for (Method m : ALL_METHODS) {
            if (!m.getName().equals(methodName)) continue;
            Assertions.assertEquals((Object)m.isAnnotationPresent(ReadOnly.class), (Object)expected, (String)("Expected ReadOnly for method '" + methodName + "' to be " + expected));
            return;
        }
        throw new IllegalArgumentException("Unknown method name: " + methodName);
    }
}

