/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHdfsFileStatusMethods {
    @Test
    public void testInterfaceSuperset() {
        Set<MethodSignature> fsM = TestHdfsFileStatusMethods.signatures(FileStatus.class);
        Set<MethodSignature> hfsM = TestHdfsFileStatusMethods.signatures(HdfsFileStatus.class);
        hfsM.addAll(Stream.of(HdfsFileStatus.class.getInterfaces()).flatMap(i -> Stream.of(i.getDeclaredMethods())).map(MethodSignature::new).collect(Collectors.toSet()));
        hfsM.addAll(TestHdfsFileStatusMethods.signatures(Object.class));
        Assertions.assertTrue((boolean)fsM.removeAll(hfsM));
        Assertions.assertEquals(Collections.emptySet(), fsM, (String)fsM.stream().map(MethodSignature::toString).collect(Collectors.joining("\n")));
    }

    private static Set<MethodSignature> signatures(Class<?> c) {
        return Stream.of(c.getDeclaredMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(MethodSignature::new).collect(Collectors.toSet());
    }

    private static class MethodSignature {
        private final String name;
        private final Type rval;
        private final Type[] param;

        MethodSignature(Method m) {
            this.name = m.getName();
            this.rval = m.getGenericReturnType();
            this.param = m.getParameterTypes();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature s = (MethodSignature)o;
            return this.name.equals(s.name) && this.rval.equals(s.rval) && Arrays.equals(this.param, s.param);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.rval).append(" ").append(this.name).append("(").append(Stream.of(this.param).map(Object::toString).collect(Collectors.joining(","))).append(")");
            return sb.toString();
        }
    }
}

