/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExtendedBlock {
    static final String POOL_A = "blockpool-a";
    static final String POOL_B = "blockpool-b";
    static final Block BLOCK_1_GS1 = new Block(1L, 100L, 1L);
    static final Block BLOCK_1_GS2 = new Block(1L, 100L, 2L);
    static final Block BLOCK_2_GS1 = new Block(2L, 100L, 1L);

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)new ExtendedBlock(POOL_A, BLOCK_1_GS1), (Object)new ExtendedBlock(POOL_A, BLOCK_1_GS1));
        TestExtendedBlock.assertNotEquals(new ExtendedBlock(POOL_A, BLOCK_1_GS1), new ExtendedBlock(POOL_B, BLOCK_1_GS1));
        TestExtendedBlock.assertNotEquals(new ExtendedBlock(POOL_A, BLOCK_1_GS1), new ExtendedBlock(POOL_A, BLOCK_2_GS1));
        Assertions.assertEquals((Object)new ExtendedBlock(POOL_A, BLOCK_1_GS1), (Object)new ExtendedBlock(POOL_A, BLOCK_1_GS2));
    }

    @Test
    public void testHashcode() {
        TestExtendedBlock.assertNotEquals(new ExtendedBlock(POOL_A, BLOCK_1_GS1).hashCode(), new ExtendedBlock(POOL_B, BLOCK_1_GS1).hashCode());
        TestExtendedBlock.assertNotEquals(new ExtendedBlock(POOL_A, BLOCK_1_GS1).hashCode(), new ExtendedBlock(POOL_A, BLOCK_2_GS1).hashCode());
        Assertions.assertEquals((int)new ExtendedBlock(POOL_A, BLOCK_1_GS1).hashCode(), (int)new ExtendedBlock(POOL_A, BLOCK_1_GS1).hashCode());
    }

    private static void assertNotEquals(Object a, Object b) {
        Assertions.assertFalse((boolean)a.equals(b), (String)("expected not equal: '" + a + "' and '" + b + "'"));
    }
}

