/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestErasureCodingPolicyInfo {
    @Test
    public void testPolicyAndStateCantBeNull() {
        try {
            new ErasureCodingPolicyInfo(null);
            Assertions.fail((String)"Null policy should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicyInfo(SystemErasureCodingPolicies.getByID((byte)1), null);
            Assertions.fail((String)"Null policy state should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testStates() {
        ErasureCodingPolicyInfo info = new ErasureCodingPolicyInfo(SystemErasureCodingPolicies.getByID((byte)1));
        info.setState(ErasureCodingPolicyState.ENABLED);
        Assertions.assertFalse((boolean)info.isDisabled());
        Assertions.assertTrue((boolean)info.isEnabled());
        Assertions.assertFalse((boolean)info.isRemoved());
        info.setState(ErasureCodingPolicyState.REMOVED);
        Assertions.assertFalse((boolean)info.isDisabled());
        Assertions.assertFalse((boolean)info.isEnabled());
        Assertions.assertTrue((boolean)info.isRemoved());
        info.setState(ErasureCodingPolicyState.DISABLED);
        Assertions.assertTrue((boolean)info.isDisabled());
        Assertions.assertFalse((boolean)info.isEnabled());
        Assertions.assertFalse((boolean)info.isRemoved());
    }
}

