/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestErasureCodingPolicy {
    private static final ECSchema SCHEMA_1 = new ECSchema("one", 1, 2, null);
    private static final ECSchema SCHEMA_2 = new ECSchema("two", 1, 2, null);

    @Test
    public void testInvalid() {
        try {
            new ErasureCodingPolicy(null, SCHEMA_1, 123, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy("policy", null, 123, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy("policy", SCHEMA_1, -1, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
        try {
            new ErasureCodingPolicy(null, 1024, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy(SCHEMA_1, -1, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
        try {
            new ErasureCodingPolicy(null, 1024);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy(SCHEMA_1, -1);
            Assertions.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        ErasureCodingPolicy[] policies = new ErasureCodingPolicy[]{new ErasureCodingPolicy("one", SCHEMA_1, 1024, 1), new ErasureCodingPolicy("two", SCHEMA_1, 1024, 1), new ErasureCodingPolicy("one", SCHEMA_2, 1024, 1), new ErasureCodingPolicy("one", SCHEMA_1, 2048, 1), new ErasureCodingPolicy("one", SCHEMA_1, 1024, 3)};
        for (int i = 0; i < policies.length; ++i) {
            ErasureCodingPolicy ei = policies[i];
            ErasureCodingPolicy temp = new ErasureCodingPolicy(ei.getName(), ei.getSchema(), ei.getCellSize(), ei.getId());
            Assertions.assertEquals((Object)ei, (Object)temp);
            Assertions.assertEquals((int)ei.hashCode(), (int)temp.hashCode());
            for (int j = 0; j < policies.length; ++j) {
                ErasureCodingPolicy ej = policies[j];
                if (i == j) {
                    Assertions.assertEquals((Object)ei, (Object)ej);
                    Assertions.assertEquals((int)ei.hashCode(), (int)ej.hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)ei, (Object)ej);
                Assertions.assertNotEquals((Object)ei, (Object)ej.hashCode());
            }
        }
    }
}

