/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestLeaseRenewer {
    private final String FAKE_AUTHORITY = "hdfs://nn1/";
    private final UserGroupInformation FAKE_UGI_A = UserGroupInformation.createUserForTesting((String)"myuser", (String[])new String[]{"group1"});
    private final UserGroupInformation FAKE_UGI_B = UserGroupInformation.createUserForTesting((String)"myuser", (String[])new String[]{"group1"});
    private DFSClient MOCK_DFSCLIENT;
    private LeaseRenewer renewer;
    private static final long FAST_GRACE_PERIOD = 100L;

    @BeforeEach
    public void setupMocksAndRenewer() throws IOException {
        this.MOCK_DFSCLIENT = this.createMockClient();
        this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        this.renewer.setGraceSleepPeriod(100L);
    }

    private DFSClient createMockClient() {
        DfsClientConf mockConf = (DfsClientConf)Mockito.mock(DfsClientConf.class);
        ((DfsClientConf)Mockito.doReturn((Object)100).when((Object)mockConf)).getHdfsTimeout();
        DFSClient mock = (DFSClient)Mockito.mock(DFSClient.class);
        ((DFSClient)Mockito.doReturn((Object)true).when((Object)mock)).isClientRunning();
        ((DFSClient)Mockito.doReturn((Object)mockConf).when((Object)mock)).getConf();
        ((DFSClient)Mockito.doReturn((Object)"myclient").when((Object)mock)).getClientName();
        return mock;
    }

    @Test
    public void testInstanceSharing() throws IOException {
        LeaseRenewer lr = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        LeaseRenewer lr2 = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        Assertions.assertSame((Object)lr, (Object)lr2);
        LeaseRenewer lr3 = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_B, (DFSClient)this.MOCK_DFSCLIENT);
        Assertions.assertNotSame((Object)lr, (Object)lr3);
        LeaseRenewer lr4 = LeaseRenewer.getInstance((String)"someOtherAuthority", (UserGroupInformation)this.FAKE_UGI_B, (DFSClient)this.MOCK_DFSCLIENT);
        Assertions.assertNotSame((Object)lr, (Object)lr4);
        Assertions.assertNotSame((Object)lr3, (Object)lr4);
    }

    @Test
    public void testRenewal() throws Exception {
        final AtomicInteger leaseRenewalCount = new AtomicInteger();
        ((DFSClient)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                leaseRenewalCount.incrementAndGet();
                return true;
            }
        }).when((Object)this.MOCK_DFSCLIENT)).renewLease();
        DFSOutputStream mockStream = (DFSOutputStream)Mockito.mock(DFSOutputStream.class);
        long fileId = 123L;
        this.renewer.put(this.MOCK_DFSCLIENT);
        long failTime = Time.monotonicNow() + 5000L;
        while (Time.monotonicNow() < failTime && leaseRenewalCount.get() == 0) {
            Thread.sleep(50L);
        }
        if (leaseRenewalCount.get() == 0) {
            Assertions.fail((String)"Did not renew lease at all!");
        }
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
    }

    @Test
    public void testManyDfsClientsWhereSomeNotOpen() throws Exception {
        final DFSClient mockClient1 = this.createMockClient();
        ((DFSClient)Mockito.doReturn((Object)false).when((Object)mockClient1)).renewLease();
        Assertions.assertSame((Object)this.renewer, (Object)LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)mockClient1));
        long fileId = 456L;
        this.renewer.put(mockClient1);
        final DFSClient mockClient2 = this.createMockClient();
        ((DFSClient)Mockito.doReturn((Object)true).when((Object)mockClient2)).renewLease();
        Assertions.assertSame((Object)this.renewer, (Object)LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)mockClient2));
        this.renewer.put(mockClient2);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    ((DFSClient)Mockito.verify((Object)mockClient1, (VerificationMode)Mockito.atLeastOnce())).renewLease();
                    ((DFSClient)Mockito.verify((Object)mockClient2, (VerificationMode)Mockito.atLeastOnce())).renewLease();
                    return true;
                }
                catch (AssertionError err) {
                    LeaseRenewer.LOG.warn("Not yet satisfied", (Throwable)((Object)err));
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (long)100L, (long)10000L);
        this.renewer.closeClient(mockClient1);
        this.renewer.closeClient(mockClient2);
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
        Thread.sleep(200L);
        Assertions.assertTrue((!this.renewer.isRunning() ? 1 : 0) != 0);
    }

    @Test
    public void testThreadName() throws Exception {
        Assertions.assertFalse((boolean)this.renewer.isRunning(), (String)"Renewer not initially running");
        this.renewer.put(this.MOCK_DFSCLIENT);
        Assertions.assertTrue((boolean)this.renewer.isRunning(), (String)"Renewer should have started running");
        String threadName = this.renewer.getDaemonName();
        Assertions.assertEquals((Object)"LeaseRenewer:myuser@hdfs://nn1/", (Object)threadName);
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
        this.renewer.setEmptyTime(Time.monotonicNow());
        long failTime = Time.monotonicNow() + 5000L;
        while (this.renewer.isRunning() && Time.monotonicNow() < failTime) {
            Thread.sleep(50L);
        }
        Assertions.assertFalse((boolean)this.renewer.isRunning());
    }

    @Test
    public void testDaemonThreadLeak() throws Exception {
        int threadCount;
        Assertions.assertFalse((boolean)this.renewer.isRunning(), (String)"Renewer not initially running");
        this.renewer.put(this.MOCK_DFSCLIENT);
        Assertions.assertTrue((boolean)this.renewer.isRunning(), (String)"Renewer should have started running");
        Pattern daemonThreadNamePattern = Pattern.compile("LeaseRenewer:\\S+");
        Assertions.assertEquals((int)1, (int)TestLeaseRenewer.countThreadMatching(daemonThreadNamePattern));
        LeaseRenewer lastRenewer = this.renewer;
        this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        Assertions.assertEquals((Object)lastRenewer, (Object)this.renewer);
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
        Assertions.assertEquals((int)1, (int)TestLeaseRenewer.countThreadMatching(daemonThreadNamePattern));
        this.renewer.setEmptyTime(0L);
        this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        this.renewer.setGraceSleepPeriod(100L);
        boolean success = this.renewer.put(this.MOCK_DFSCLIENT);
        if (!success) {
            LeaseRenewer.remove((LeaseRenewer)this.renewer);
            this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
            this.renewer.setGraceSleepPeriod(100L);
            this.renewer.put(this.MOCK_DFSCLIENT);
        }
        Assertions.assertTrue((1 == (threadCount = TestLeaseRenewer.countThreadMatching(daemonThreadNamePattern)) || 2 == threadCount ? 1 : 0) != 0);
        Thread.sleep(200L);
        lastRenewer = this.renewer;
        this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        Assertions.assertEquals((Object)lastRenewer, (Object)this.renewer);
        this.renewer.setGraceSleepPeriod(100L);
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
        this.renewer.setEmptyTime(0L);
        Thread.sleep(200L);
        Assertions.assertEquals((int)0, (int)TestLeaseRenewer.countThreadMatching(daemonThreadNamePattern), (String)"LeaseRenewer#daemon thread leaks");
    }

    private static int countThreadMatching(Pattern pattern) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 1);
        int count = 0;
        for (ThreadInfo info : infos) {
            if (info == null || !pattern.matcher(info.getThreadName()).matches()) continue;
            ++count;
        }
        return count;
    }
}

