/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultNameNodePort {
    @Test
    public void testGetAddressFromString() throws Exception {
        Assertions.assertEquals((int)8020, (int)DFSUtilClient.getNNAddress((String)"foo").getPort());
        Assertions.assertEquals((int)8020, (int)DFSUtilClient.getNNAddress((String)"hdfs://foo/").getPort());
        Assertions.assertEquals((int)555, (int)DFSUtilClient.getNNAddress((String)"hdfs://foo:555").getPort());
        Assertions.assertEquals((int)555, (int)DFSUtilClient.getNNAddress((String)"foo:555").getPort());
    }

    @Test
    public void testGetAddressFromConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo/");
        Assertions.assertEquals((int)8020, (int)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo:555/");
        Assertions.assertEquals((int)555, (int)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo");
        Assertions.assertEquals((int)8020, (int)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo:555");
        Assertions.assertEquals((int)555, (int)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
    }

    @Test
    public void testGetUri() {
        Assertions.assertEquals((Object)URI.create("hdfs://foo:555"), (Object)DFSUtilClient.getNNUri((InetSocketAddress)new InetSocketAddress("foo", 555)));
        Assertions.assertEquals((Object)URI.create("hdfs://foo"), (Object)DFSUtilClient.getNNUri((InetSocketAddress)new InetSocketAddress("foo", 8020)));
    }
}

