/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=10L)
public class TestDFSOpsCountStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSOpsCountStatistics.class);
    private static final String NO_SUCH_OP = "no-such-dfs-operation-dude";
    private final DFSOpsCountStatistics statistics = new DFSOpsCountStatistics();
    private final Map<DFSOpsCountStatistics.OpType, AtomicLong> expectedOpsCountMap = new HashMap<DFSOpsCountStatistics.OpType, AtomicLong>();

    @BeforeEach
    public void setup() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            this.expectedOpsCountMap.put(opType, new AtomicLong());
        }
        this.incrementOpsCountByRandomNumbers();
    }

    @Test
    public void testOpTypeSymbolsAreUnique() {
        HashSet<String> opTypeSymbols = new HashSet<String>();
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Assertions.assertFalse((boolean)opTypeSymbols.contains(opType.getSymbol()));
            opTypeSymbols.add(opType.getSymbol());
        }
        Assertions.assertEquals((int)DFSOpsCountStatistics.OpType.values().length, (int)opTypeSymbols.size());
    }

    @Test
    public void testGetLongStatistics() {
        int iterations = 0;
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assertions.assertNotNull((Object)longStat);
            DFSOpsCountStatistics.OpType opType = DFSOpsCountStatistics.OpType.fromSymbol((String)longStat.getName());
            Assertions.assertNotNull((Object)opType);
            Assertions.assertTrue((boolean)this.expectedOpsCountMap.containsKey(opType));
            Assertions.assertEquals((long)this.expectedOpsCountMap.get(opType).longValue(), (long)longStat.getValue());
            iterations = (short)(iterations + 1);
        }
        Assertions.assertEquals((int)DFSOpsCountStatistics.OpType.values().length, (int)iterations);
    }

    @Test
    public void testGetLong() {
        Assertions.assertNull((Object)this.statistics.getLong(null));
        Assertions.assertNull((Object)this.statistics.getLong(NO_SUCH_OP));
        this.verifyStatistics();
    }

    @Test
    public void testIsTracked() {
        Assertions.assertFalse((boolean)this.statistics.isTracked(null));
        Assertions.assertFalse((boolean)this.statistics.isTracked(NO_SUCH_OP));
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStatistic = (StorageStatistics.LongStatistic)iter.next();
            Assertions.assertTrue((boolean)this.statistics.isTracked(longStatistic.getName()));
        }
    }

    @Test
    public void testReset() {
        this.statistics.reset();
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            this.expectedOpsCountMap.get(opType).set(0L);
        }
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assertions.assertEquals((long)0L, (long)longStat.getValue());
        }
        this.incrementOpsCountByRandomNumbers();
        this.verifyStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentAccess() throws InterruptedException {
        int numThreads = 10;
        ExecutorService threadPool = HadoopExecutors.newFixedThreadPool((int)10);
        try {
            final CountDownLatch allReady = new CountDownLatch(10);
            final CountDownLatch startBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(10);
            final AtomicReference childError = new AtomicReference();
            for (int i = 0; i < 10; ++i) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allReady.countDown();
                        try {
                            startBlocker.await();
                            TestDFSOpsCountStatistics.this.incrementOpsCountByRandomNumbers();
                        }
                        catch (Throwable t) {
                            LOG.error("Child failed when calling mkdir", t);
                            childError.compareAndSet(null, t);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            allReady.await();
            startBlocker.countDown();
            allDone.await();
            Assertions.assertNull(childError.get(), (String)"Child failed with exception.");
            this.verifyStatistics();
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    private void incrementOpsCountByRandomNumbers() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Long randomCount = RandomUtils.nextLong((long)0L, (long)100L);
            this.expectedOpsCountMap.get(opType).addAndGet(randomCount);
            for (long i = 0L; i < randomCount; ++i) {
                this.statistics.incrementOpCounter(opType);
            }
        }
    }

    private void verifyStatistics() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Assertions.assertNotNull((Object)this.expectedOpsCountMap.get(opType));
            Assertions.assertNotNull((Object)this.statistics.getLong(opType.getSymbol()));
            Assertions.assertEquals((long)this.expectedOpsCountMap.get(opType).longValue(), (long)this.statistics.getLong(opType.getSymbol()), (String)("Not expected count for operation " + opType.getSymbol()));
        }
    }
}

