/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;

public class SnapshotStatus {
    private final HdfsFileStatus dirStatus;
    private final int snapshotID;
    private final boolean isDeleted;
    private byte[] parentFullPath;

    public SnapshotStatus(long modificationTime, long accessTime, FsPermission permission, EnumSet<HdfsFileStatus.Flags> flags, String owner, String group, byte[] localName, long inodeId, int childrenNum, int snapshotID, boolean isDeleted, byte[] parentFullPath) {
        this.dirStatus = new HdfsFileStatus.Builder().isdir(true).mtime(modificationTime).atime(accessTime).perm(permission).flags(flags).owner(owner).group(group).path(localName).fileId(inodeId).children(childrenNum).build();
        this.snapshotID = snapshotID;
        this.isDeleted = isDeleted;
        this.parentFullPath = parentFullPath;
    }

    public SnapshotStatus(HdfsFileStatus dirStatus, int snapshotID, boolean isDeleted, byte[] parentFullPath) {
        this.dirStatus = dirStatus;
        this.snapshotID = snapshotID;
        this.isDeleted = isDeleted;
        this.parentFullPath = parentFullPath;
    }

    public void setParentFullPath(byte[] path) {
        this.parentFullPath = path;
    }

    public int getSnapshotID() {
        return this.snapshotID;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public HdfsFileStatus getDirStatus() {
        return this.dirStatus;
    }

    public byte[] getParentFullPath() {
        return this.parentFullPath;
    }

    public Path getFullPath() {
        String parentFullPathStr = this.parentFullPath == null || this.parentFullPath.length == 0 ? "/" : DFSUtilClient.bytes2String(this.parentFullPath);
        return new Path(SnapshotStatus.getSnapshotPath(parentFullPathStr, this.dirStatus.getLocalName()));
    }

    public static void print(SnapshotStatus[] stats, PrintStream out) {
        if (stats == null || stats.length == 0) {
            out.println();
            return;
        }
        int maxRepl = 0;
        int maxLen = 0;
        int maxOwner = 0;
        int maxGroup = 0;
        int maxSnapshotID = 0;
        for (SnapshotStatus status : stats) {
            maxRepl = SnapshotStatus.maxLength(maxRepl, status.dirStatus.getReplication());
            maxLen = SnapshotStatus.maxLength(maxLen, status.dirStatus.getLen());
            maxOwner = SnapshotStatus.maxLength(maxOwner, status.dirStatus.getOwner());
            maxGroup = SnapshotStatus.maxLength(maxGroup, status.dirStatus.getGroup());
            maxSnapshotID = SnapshotStatus.maxLength(maxSnapshotID, status.snapshotID);
        }
        String lineFormat = "%s%s %" + maxRepl + "s " + (String)(maxOwner > 0 ? "%-" + maxOwner + "s " : "%s") + (String)(maxGroup > 0 ? "%-" + maxGroup + "s " : "%s") + "%" + maxLen + "s %s %" + maxSnapshotID + "s %s %s";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (SnapshotStatus status : stats) {
            String line = String.format(lineFormat, "d", status.dirStatus.getPermission(), status.dirStatus.getReplication(), status.dirStatus.getOwner(), status.dirStatus.getGroup(), String.valueOf(status.dirStatus.getLen()), dateFormat.format(new Date(status.dirStatus.getModificationTime())), status.snapshotID, status.isDeleted ? "DELETED" : "ACTIVE", SnapshotStatus.getSnapshotPath(DFSUtilClient.bytes2String(status.parentFullPath), status.dirStatus.getLocalName()));
            out.println(line);
        }
    }

    private static int maxLength(int n, Object value) {
        return Math.max(n, String.valueOf(value).length());
    }

    public static String getSnapshotPath(String snapshottableDir, String snapshotRelativePath) {
        String parentFullPathStr = snapshottableDir == null || snapshottableDir.isEmpty() ? "/" : snapshottableDir;
        StringBuilder b = new StringBuilder(parentFullPathStr);
        if (b.charAt(b.length() - 1) != '/') {
            b.append("/");
        }
        return b.append(".snapshot").append("/").append(snapshotRelativePath).toString();
    }

    public static String getParentPath(String snapshotPath) {
        int index = snapshotPath.indexOf(".snapshot");
        return index == -1 ? snapshotPath : snapshotPath.substring(0, index - 1);
    }
}

