/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.commons.collections4.list.TreeList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.client.impl.SnapshotDiffReportGenerator;
import org.apache.hadoop.hdfs.net.BasicInetPeer;
import org.apache.hadoop.hdfs.net.NioInetPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.ReconfigurationProtocol;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.primitives.SignedBytes;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DFSUtilClient {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final Logger LOG = LoggerFactory.getLogger(DFSUtilClient.class);
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final Map<String, Boolean> localAddrMap = Collections.synchronizedMap(new HashMap());
    private static final int INODE_PATH_MAX_LENGTH = 3 * "/".length() + ".reserved".length() + ".inodes".length() + (int)Math.ceil(Math.log10(9.223372036854776E18)) + 1;

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtilClient.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[][] bytes2byteArray(byte[] bytes) {
        return DFSUtilClient.bytes2byteArray(bytes, bytes.length, (byte)47);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        if (len < 0 || len > bytes.length) {
            throw new IndexOutOfBoundsException("Incorrect index [len, size] [" + len + ", " + bytes.length + "]");
        }
        if (len == 0) {
            return new byte[][]{null};
        }
        int splits = 0;
        for (int i = 1; i < len; ++i) {
            if (bytes[i - 1] != separator || bytes[i] == separator) continue;
            ++splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int nextIndex = 0;
        for (int i = 0; i < splits; ++i) {
            int startIndex = nextIndex;
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            byte[] byArray = result[i] = nextIndex > 0 ? Arrays.copyOfRange(bytes, startIndex, nextIndex) : EMPTY_BYTES;
            while (++nextIndex < len && bytes[nextIndex] == separator) {
            }
        }
        return result;
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static String percent2String(double percentage) {
        return StringUtils.format((String)"%.2f%%", (Object[])new Object[]{percentage});
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getTrimmedStringCollection("dfs.nameservices");
    }

    public static Collection<String> getNameNodeIds(Configuration conf, String nsId) {
        String key = DFSUtilClient.addSuffix("dfs.ha.namenodes", nsId);
        return conf.getTrimmedStringCollection(key);
    }

    static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration conf) {
        return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.rpc-address");
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnWebHdfsAddresses(Configuration conf, String scheme) {
        if ("webhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.http-address");
        }
        if ("swebhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.https-address");
        }
        throw new IllegalArgumentException("Unsupported scheme: " + scheme);
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        return DFSUtilClient.locatedBlocks2Locations(blocks.getLocatedBlocks());
    }

    public static BlockLocation[] locatedBlocks2Locations(List<LocatedBlock> blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.size();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfoWithStorage[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] xferAddrs = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                xferAddrs[hCnt] = locations[hCnt].getXferAddr();
                NodeBase node = new NodeBase(xferAddrs[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            DatanodeInfo[] cachedLocations = blk.getCachedLocations();
            String[] cachedHosts = new String[cachedLocations.length];
            for (int i = 0; i < cachedLocations.length; ++i) {
                cachedHosts[i] = cachedLocations[i].getHostName();
            }
            blkLocations[idx] = new BlockLocation(xferAddrs, hosts, cachedHosts, racks, blk.getStorageIDs(), blk.getStorageTypes(), blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    public static int compareBytes(byte[] left, byte[] right) {
        if (left == null) {
            left = EMPTY_BYTES;
        }
        if (right == null) {
            right = EMPTY_BYTES;
        }
        return SignedBytes.lexicographicalComparator().compare(left, right);
    }

    public static byte[] byteArray2bytes(byte[][] pathComponents) {
        if (pathComponents.length == 0 || pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return EMPTY_BYTES;
        }
        int length = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            length += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            ++length;
        }
        byte[] path = new byte[length];
        int index = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            System.arraycopy(pathComponents[i], 0, path, index, pathComponents[i].length);
            index += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            path[index] = 47;
            ++index;
        }
        return path;
    }

    public static String byteArray2String(byte[][] pathComponents) {
        return DFSUtilClient.bytes2String(DFSUtilClient.byteArray2bytes(pathComponents));
    }

    static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on((String)".").skipNulls().join((Object[])suffixes);
    }

    public static Map<String, Map<String, InetSocketAddress>> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtilClient.getNameServiceIds(conf);
        return DFSUtilClient.getAddressesForNsIds(conf, nameserviceIds, defaultAddress, keys);
    }

    static Map<String, InetSocketAddress> getResolvedAddressesForNsId(Configuration conf, String nsId, DomainNameResolver dnr, String defaultValue, String ... keys) {
        Collection<String> nnIds = DFSUtilClient.getNameNodeIds(conf, nsId);
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nnId : DFSUtilClient.emptyAsSingletonNull(nnIds)) {
            Map<String, InetSocketAddress> resolvedAddressesForNnId = DFSUtilClient.getResolvedAddressesForNnId(conf, nsId, nnId, dnr, defaultValue, keys);
            ret.putAll(resolvedAddressesForNnId);
        }
        return ret;
    }

    public static Map<String, InetSocketAddress> getResolvedAddressesForNnId(Configuration conf, String nsId, String nnId, DomainNameResolver dnr, String defaultValue, String ... keys) {
        String suffix = DFSUtilClient.concatSuffixes(nsId, nnId);
        String address = DFSUtilClient.checkKeysAndProcess(defaultValue, suffix, conf, keys);
        LinkedHashMap ret = Maps.newLinkedHashMap();
        if (address != null) {
            InetSocketAddress isa = NetUtils.createSocketAddr((String)address);
            try {
                String[] resolvedHostNames = dnr.getAllResolvedHostnameByDomainName(isa.getHostName(), true);
                int port = isa.getPort();
                for (String hostname : resolvedHostNames) {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(hostname, port);
                    String concatId = DFSUtilClient.getConcatNnId(nsId, nnId, hostname, port);
                    ret.put(concatId, inetSocketAddress);
                }
            }
            catch (UnknownHostException e) {
                LOG.error("Failed to resolve address: {}", (Object)address);
            }
        }
        return ret;
    }

    private static String getConcatNnId(String nsId, String nnId, String hostname, int port) {
        if (nnId == null || nnId.isEmpty()) {
            return String.join((CharSequence)"-", nsId, hostname, String.valueOf(port));
        }
        return String.join((CharSequence)"-", nsId, nnId, hostname, String.valueOf(port));
    }

    static Map<String, Map<String, InetSocketAddress>> getAddressesForNsIds(Configuration conf, Collection<String> nsIds, String defaultAddress, String ... keys) {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nsId : DFSUtilClient.emptyAsSingletonNull(nsIds)) {
            Map<String, InetSocketAddress> isas = DFSUtilClient.getAddressesForNameserviceId(conf, nsId, defaultAddress, keys);
            if (isas.isEmpty()) continue;
            ret.put(nsId, isas);
        }
        return ret;
    }

    public static Map<String, InetSocketAddress> getAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue, String ... keys) {
        Collection<String> nnIds = DFSUtilClient.getNameNodeIds(conf, nsId);
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nnId : DFSUtilClient.emptyAsSingletonNull(nnIds)) {
            String suffix = DFSUtilClient.concatSuffixes(nsId, nnId);
            String address = DFSUtilClient.checkKeysAndProcess(defaultValue, suffix, conf, keys);
            if (address == null) continue;
            InetSocketAddress isa = null;
            if (conf.getBoolean("dfs.client.failover.lazy.resolved", false)) {
                isa = NetUtils.createSocketAddrUnresolved((String)address);
            } else {
                isa = NetUtils.createSocketAddr((String)address);
                if (isa.isUnresolved()) {
                    LOG.warn("Namenode for {} remains unresolved for ID {}. Check your hdfs-site.xml file to ensure namenodes are configured properly.", (Object)nsId, (Object)nnId);
                }
            }
            ret.put(nnId, isa);
        }
        return ret;
    }

    private static String checkKeysAndProcess(String defaultValue, String suffix, Configuration conf, String ... keys) {
        String succeededKey = null;
        String address = null;
        for (String key : keys) {
            address = DFSUtilClient.getConfValue(null, suffix, conf, key);
            if (address == null) continue;
            succeededKey = key;
            break;
        }
        String ret = address == null ? defaultValue : ("dfs.namenode.rpc-address".equals(succeededKey) ? DFSUtilClient.checkRpcAuxiliary(conf, suffix, address) : address);
        return ret;
    }

    private static String checkRpcAuxiliary(Configuration conf, String suffix, String address) {
        URI uri;
        String key = "dfs.namenode.rpc-address.auxiliary-ports";
        int[] ports = conf.getInts(key = DFSUtilClient.addSuffix(key, suffix));
        if (ports == null || ports.length == 0) {
            return address;
        }
        LOG.info("Using server auxiliary ports {}", (Object)Arrays.toString(ports));
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            LOG.warn("NameNode address is not a valid uri:{}", (Object)address);
            return address;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme()).append("://").append(uri.getHost()).append(":");
        sb.append(ports[0]);
        return sb.toString();
    }

    public static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            value = conf.get(key = DFSUtilClient.addSuffix(key, keySuffix));
            if (value != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = StringUtils.split((String)src, (char)'/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (Shell.WINDOWS && i == 1 && element.endsWith(":")) continue;
            if (element.equals(".") || element.contains(":") || element.contains("/")) {
                return false;
            }
            if (element.equals("..")) {
                if (components.length > 4 && components[1].equals(".reserved") && components[2].equals(".inodes")) continue;
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }

    public static String durationToString(long durationMs) {
        boolean negative = false;
        if (durationMs < 0L) {
            negative = true;
            durationMs = -durationMs;
        }
        long durationSec = durationMs / 1000L;
        int secondsPerMinute = 60;
        int secondsPerHour = 3600;
        int secondsPerDay = 86400;
        long days = durationSec / 86400L;
        long hours = (durationSec -= days * 86400L) / 3600L;
        long minutes = (durationSec -= hours * 3600L) / 60L;
        long seconds = durationSec -= minutes * 60L;
        long milliseconds = durationMs % 1000L;
        Object format = "%03d:%02d:%02d:%02d.%03d";
        if (negative) {
            format = "-" + (String)format;
        }
        return String.format((String)format, days, hours, minutes, seconds, milliseconds);
    }

    public static String dateToIso8601String(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
        return df.format(date);
    }

    public static boolean isLocalAddress(InetSocketAddress targetAddr) throws IOException {
        if (targetAddr.isUnresolved()) {
            throw new IOException("Unresolved host: " + targetAddr);
        }
        InetAddress addr = targetAddr.getAddress();
        Boolean cached = localAddrMap.get(addr.getHostAddress());
        if (cached != null) {
            LOG.trace("Address {} is{} local", (Object)targetAddr, (Object)(cached != false ? "" : " not"));
            return cached;
        }
        boolean local = NetUtils.isLocalAddress((InetAddress)addr);
        LOG.trace("Address {} is{} local", (Object)targetAddr, (Object)(local ? "" : " not"));
        localAddrMap.put(addr.getHostAddress(), local);
        return local;
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    public static ReconfigurationProtocol createReconfigurationProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ReconfigurationProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocket(Socket socket) throws IOException {
        boolean success = false;
        try {
            socket.setTcpNoDelay(true);
            SocketChannel channel = socket.getChannel();
            Peer peer = channel == null ? new BasicInetPeer(socket) : new NioInetPeer(socket);
            success = true;
            Peer peer2 = peer;
            return peer2;
        }
        finally {
            if (!success) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocketAndKey(SaslDataTransferClient saslClient, Socket s, DataEncryptionKeyFactory keyFactory, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId, int socketTimeoutMs) throws IOException {
        Peer peer;
        block3: {
            Peer peer2 = null;
            boolean success = false;
            try {
                peer2 = DFSUtilClient.peerFromSocket(s);
                peer2.setReadTimeout(socketTimeoutMs);
                peer2.setWriteTimeout(socketTimeoutMs);
                peer2 = saslClient.peerSend(peer2, keyFactory, blockToken, datanodeId);
                success = true;
                peer = peer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtilsClient.cleanupWithLogger(LOG, peer2);
                }
                throw throwable;
            }
            IOUtilsClient.cleanupWithLogger(LOG, peer2);
        }
        return peer;
    }

    public static int getIoFileBufferSize(Configuration conf) {
        return conf.getInt("io.file.buffer.size", 4096);
    }

    public static int getSmallBufferSize(Configuration conf) {
        return Math.min(DFSUtilClient.getIoFileBufferSize(conf) / 2, 512);
    }

    public static boolean isHDFSEncryptionEnabled(Configuration conf) {
        return !conf.getTrimmed("hadoop.security.key.provider.path", "").isEmpty();
    }

    public static InetSocketAddress getNNAddress(String address) {
        return NetUtils.createSocketAddr((String)address, (int)8020);
    }

    public static InetSocketAddress getNNAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        return DFSUtilClient.getNNAddressCheckLogical(conf, filesystemURI);
    }

    public static InetSocketAddress getNNAddress(URI filesystemURI) {
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return DFSUtilClient.getNNAddress(authority);
    }

    public static InetSocketAddress getNNAddressCheckLogical(Configuration conf, URI filesystemURI) {
        InetSocketAddress retAddr = HAUtilClient.isLogicalUri(conf, filesystemURI) ? InetSocketAddress.createUnresolved(filesystemURI.getAuthority(), 8020) : DFSUtilClient.getNNAddress(filesystemURI);
        return retAddr;
    }

    public static URI getNNUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        Object portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + (String)portString);
    }

    public static InterruptedIOException toInterruptedIOException(String message, InterruptedException e) {
        InterruptedIOException iioe = new InterruptedIOException(message);
        iioe.initCause(e);
        return iioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOStreamPair connectToDN(DatanodeInfo dn, int timeout, Configuration conf, SaslDataTransferClient saslClient, SocketFactory socketFactory, boolean connectToDnViaHostname, DataEncryptionKeyFactory dekFactory, Token<BlockTokenIdentifier> blockToken) throws IOException {
        boolean success = false;
        Socket sock = null;
        try {
            sock = socketFactory.createSocket();
            String dnAddr = dn.getXferAddr(connectToDnViaHostname);
            LOG.debug("Connecting to datanode {}", (Object)dnAddr);
            NetUtils.connect((Socket)sock, (SocketAddress)NetUtils.createSocketAddr((String)dnAddr), (int)timeout);
            sock.setTcpNoDelay(DFSUtilClient.getClientDataTransferTcpNoDelay(conf));
            sock.setSoTimeout(timeout);
            OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock);
            SocketInputWrapper unbufIn = NetUtils.getInputStream((Socket)sock);
            IOStreamPair pair = saslClient.newSocketSend(sock, unbufOut, (InputStream)unbufIn, dekFactory, blockToken, dn);
            IOStreamPair result = new IOStreamPair(new DataInputStream(pair.in), new DataOutputStream(new BufferedOutputStream(pair.out, DFSUtilClient.getSmallBufferSize(conf))));
            success = true;
            IOStreamPair iOStreamPair = result;
            return iOStreamPair;
        }
        finally {
            if (!success) {
                IOUtils.closeSocket((Socket)sock);
            }
        }
    }

    private static boolean getClientDataTransferTcpNoDelay(Configuration conf) {
        return conf.getBoolean("dfs.data.transfer.client.tcpnodelay", true);
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTimeSecs, String threadNamePrefix, boolean runRejectedExec) {
        return DFSUtilClient.getThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTimeSecs, new SynchronousQueue<Runnable>(), threadNamePrefix, runRejectedExec);
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTimeSecs, BlockingQueue<Runnable> queue, final String threadNamePrefix, boolean runRejectedExec) {
        Preconditions.checkArgument((corePoolSize > 0 ? 1 : 0) != 0);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTimeSecs, TimeUnit.SECONDS, queue, (ThreadFactory)new Daemon.DaemonFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                Thread t = super.newThread(r);
                t.setName(threadNamePrefix + this.threadIndex.getAndIncrement());
                return t;
            }
        });
        if (runRejectedExec) {
            threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor e) {
                    LOG.info("{} task is rejected by ThreadPoolExecutor. Executing it in current thread.", (Object)threadNamePrefix);
                    super.rejectedExecution(runnable, e);
                }
            });
        }
        return threadPoolExecutor;
    }

    public static Path makePathFromFileId(long fileId) {
        StringBuilder sb = new StringBuilder(INODE_PATH_MAX_LENGTH);
        sb.append("/").append(".reserved").append("/").append(".inodes").append("/").append(fileId);
        return new Path(sb.toString());
    }

    public static String getHomeDirectory(Configuration conf, UserGroupInformation ugi) {
        String userHomePrefix = "/user";
        if (conf != null) {
            userHomePrefix = conf.get("dfs.user.home.dir.prefix", "/user");
        }
        return userHomePrefix + "/" + ugi.getShortUserName();
    }

    public static String getTrashRoot(Configuration conf, UserGroupInformation ugi) {
        return DFSUtilClient.getHomeDirectory(conf, ugi) + "/.Trash";
    }

    public static String getEZTrashRoot(EncryptionZone ez, UserGroupInformation ugi) {
        String ezpath = ez.getPath();
        return (String)(ezpath.equals("/") ? ezpath : ezpath + "/") + ".Trash/" + ugi.getShortUserName();
    }

    public static String getSnapshotTrashRoot(String ssRoot, UserGroupInformation ugi) {
        return (String)(ssRoot.equals("/") ? ssRoot : ssRoot + "/") + ".Trash/" + ugi.getShortUserName();
    }

    public static boolean isValidSnapshotName(String snapshotName) {
        return snapshotName != null && !snapshotName.isEmpty();
    }

    public static SnapshotDiffReport getSnapshotDiffReport(String snapshotDir, String fromSnapshot, String toSnapshot, SnapshotDiffReportFunction withoutListing, SnapshotDiffReportListingFunction withListing) throws IOException {
        SnapshotDiffReportListing report;
        if (!DFSUtilClient.isValidSnapshotName(fromSnapshot) || !DFSUtilClient.isValidSnapshotName(toSnapshot)) {
            return withoutListing.apply(snapshotDir, fromSnapshot, toSnapshot);
        }
        byte[] startPath = EMPTY_BYTES;
        int index = -1;
        TreeList modifiedList = new TreeList();
        ChunkedArrayList createdList = new ChunkedArrayList();
        ChunkedArrayList deletedList = new ChunkedArrayList();
        do {
            try {
                report = withListing.apply(snapshotDir, fromSnapshot, toSnapshot, startPath, index);
            }
            catch (UnsupportedOperationException | RpcNoSuchMethodException e) {
                LOG.warn("Falling back to getSnapshotDiffReport {}", (Object)e.getMessage());
                return withoutListing.apply(snapshotDir, fromSnapshot, toSnapshot);
            }
            startPath = report.getLastPath();
            index = report.getLastIndex();
            modifiedList.addAll(report.getModifyList());
            createdList.addAll(report.getCreateList());
            deletedList.addAll(report.getDeleteList());
        } while (!Arrays.equals(startPath, EMPTY_BYTES) || index != -1);
        SnapshotDiffReportGenerator snapshotDiffReport = new SnapshotDiffReportGenerator(snapshotDir, fromSnapshot, toSnapshot, report.getIsFromEarlier(), (List<SnapshotDiffReportListing.DiffReportListingEntry>)modifiedList, (List<SnapshotDiffReportListing.DiffReportListingEntry>)createdList, (List<SnapshotDiffReportListing.DiffReportListingEntry>)deletedList);
        return snapshotDiffReport.generateReport();
    }

    @FunctionalInterface
    public static interface SnapshotDiffReportFunction {
        public SnapshotDiffReport apply(String var1, String var2, String var3) throws IOException;
    }

    @FunctionalInterface
    public static interface SnapshotDiffReportListingFunction {
        public SnapshotDiffReportListing apply(String var1, String var2, String var3, byte[] var4, int var5) throws IOException;
    }

    public static class CorruptedBlocks {
        private Map<ExtendedBlock, Set<DatanodeInfo>> corruptionMap;

        public void addCorruptedBlock(ExtendedBlock blk, DatanodeInfo node) {
            Set<DatanodeInfo> dnSet;
            if (this.corruptionMap == null) {
                this.corruptionMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
            }
            if ((dnSet = this.corruptionMap.get(blk)) == null) {
                dnSet = new HashSet<DatanodeInfo>();
                this.corruptionMap.put(blk, dnSet);
            }
            if (!dnSet.contains(node)) {
                dnSet.add(node);
            }
        }

        public Map<ExtendedBlock, Set<DatanodeInfo>> getCorruptionMap() {
            return this.corruptionMap;
        }
    }
}

