/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.RandomAlgorithms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePool {
    public static final Logger LOG = LoggerFactory.getLogger(FilePool.class);
    public static final String GRIDMIX_MIN_FILE = "gridmix.min.file.size";
    public static final String GRIDMIX_MAX_TOTAL = "gridmix.max.total.scan";
    private Node root = null;
    private final Path path;
    private final FileSystem fs;
    private final Configuration conf;
    private final ReadWriteLock updateLock;

    public FilePool(Configuration conf, Path input) throws IOException {
        this.conf = conf;
        this.path = input;
        this.fs = this.path.getFileSystem(conf);
        this.updateLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInputFiles(long minSize, Collection<FileStatus> files) throws IOException {
        this.updateLock.readLock().lock();
        try {
            long l = this.root.selectFiles(minSize, files);
            return l;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    public void refresh() throws IOException {
        this.updateLock.writeLock().lock();
        try {
            this.root = new InnerDesc(this.fs, this.fs.getFileStatus(this.path), new MinFileFilter(this.conf.getLong(GRIDMIX_MIN_FILE, 0x8000000L), this.conf.getLong(GRIDMIX_MAX_TOTAL, 0x640000000000L)));
            if (0L == this.root.getSize()) {
                throw new IOException("Found no satisfactory file in " + this.path);
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    public BlockLocation[] locationsFor(FileStatus stat, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(stat, start, len);
    }

    static abstract class Node {
        protected static final Random rand = new Random();

        Node() {
        }

        abstract long getSize();

        abstract long selectFiles(long var1, Collection<FileStatus> var3) throws IOException;
    }

    static class InnerDesc
    extends Node {
        final long size;
        final double[] dist;
        final Node[] subdir;
        private static final Comparator<Node> nodeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return n1.getSize() < n2.getSize() ? -1 : (n1.getSize() > n2.getSize() ? 1 : 0);
            }
        };

        InnerDesc(FileSystem fs, FileStatus thisDir, MinFileFilter filter) throws IOException {
            long fileSum = 0L;
            ArrayList<FileStatus> curFiles = new ArrayList<FileStatus>();
            ArrayList<FileStatus> curDirs = new ArrayList<FileStatus>();
            for (FileStatus stat : fs.listStatus(thisDir.getPath())) {
                if (stat.isDirectory()) {
                    curDirs.add(stat);
                    continue;
                }
                if (!filter.accept(stat)) continue;
                curFiles.add(stat);
                fileSum += stat.getLen();
            }
            ArrayList<Node> subdirList = new ArrayList<Node>();
            if (!curFiles.isEmpty()) {
                subdirList.add(new LeafDesc(curFiles, fileSum));
            }
            Iterator i = curDirs.iterator();
            while (!filter.done() && i.hasNext()) {
                InnerDesc d = new InnerDesc(fs, (FileStatus)i.next(), filter);
                long dSize = ((Node)d).getSize();
                if (dSize <= 0L) continue;
                fileSum += dSize;
                subdirList.add(d);
            }
            this.size = fileSum;
            LOG.debug(this.size + " bytes in " + thisDir.getPath());
            this.subdir = subdirList.toArray(new Node[subdirList.size()]);
            Arrays.sort(this.subdir, nodeComparator);
            this.dist = new double[this.subdir.length];
            for (int i2 = this.dist.length - 1; i2 > 0; --i2) {
                this.dist[i2] = (double)(fileSum -= this.subdir[i2].getSize()) / (1.0 * (double)this.size);
            }
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public long selectFiles(long targetSize, Collection<FileStatus> files) throws IOException {
            long added;
            long ret = 0L;
            if (targetSize >= this.getSize()) {
                for (Node n : this.subdir) {
                    long added2 = n.selectFiles(targetSize, files);
                    ret += added2;
                    targetSize -= added2;
                }
                return ret;
            }
            HashSet<Node> sub = new HashSet<Node>();
            do {
                assert (sub.size() < this.subdir.length);
                double r = rand.nextDouble();
                int pos = Math.abs(Arrays.binarySearch(this.dist, r) + 1) - 1;
                while (sub.contains(this.subdir[pos])) {
                    pos = (pos + 1) % this.subdir.length;
                }
                added = this.subdir[pos].selectFiles(targetSize, files);
                ret += added;
                sub.add(this.subdir[pos]);
            } while ((targetSize -= added) > 0L);
            return ret;
        }
    }

    private static class MinFileFilter {
        private long totalScan;
        private final long minFileSize;

        public MinFileFilter(long minFileSize, long totalScan) {
            this.minFileSize = minFileSize;
            this.totalScan = totalScan;
        }

        public boolean done() {
            return this.totalScan <= 0L;
        }

        public boolean accept(FileStatus stat) {
            boolean done = this.done();
            if (!done && stat.getLen() >= this.minFileSize) {
                this.totalScan -= stat.getLen();
                return true;
            }
            return false;
        }
    }

    static class LeafDesc
    extends Node {
        final long size;
        final ArrayList<FileStatus> curdir;

        LeafDesc(ArrayList<FileStatus> curdir, long size) {
            this.size = size;
            this.curdir = curdir;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public long selectFiles(long targetSize, Collection<FileStatus> files) throws IOException {
            int index;
            if (targetSize >= this.getSize()) {
                files.addAll(this.curdir);
                return this.getSize();
            }
            RandomAlgorithms.Selector selector = new RandomAlgorithms.Selector(this.curdir.size(), (double)targetSize / (double)this.getSize(), rand);
            ArrayList<Integer> selected = new ArrayList<Integer>();
            long ret = 0L;
            do {
                index = selector.next();
                selected.add(index);
            } while ((ret += this.curdir.get(index).getLen()) < targetSize);
            for (Integer i : selected) {
                files.add(this.curdir.get(i));
            }
            return ret;
        }
    }
}

