/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.gs.GoogleCloudStorageFileSystem;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.apache.hadoop.fs.gs.StringPaths;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

final class UriPaths {
    private UriPaths() {
    }

    public static URI toDirectory(URI path) {
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isStorageObject() && !resourceId.isDirectory()) {
            resourceId = resourceId.toDirectoryId();
            path = UriPaths.fromResourceId(resourceId, false);
        }
        return path;
    }

    public static URI getParentPath(URI path) {
        Preconditions.checkNotNull((Object)path);
        if (path.equals(GoogleCloudStorageFileSystem.GCSROOT)) {
            return null;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            return GoogleCloudStorageFileSystem.GCSROOT;
        }
        String objectName = resourceId.getObjectName();
        int index = StringPaths.isDirectoryPath(objectName) ? objectName.lastIndexOf("/", objectName.length() - 2) : objectName.lastIndexOf("/");
        return index < 0 ? UriPaths.fromStringPathComponents(resourceId.getBucketName(), null, true) : UriPaths.fromStringPathComponents(resourceId.getBucketName(), objectName.substring(0, index + 1), false);
    }

    public static URI fromResourceId(StorageResourceId resourceId, boolean allowEmptyObjectName) {
        return UriPaths.fromStringPathComponents(resourceId.getBucketName(), resourceId.getObjectName(), allowEmptyObjectName);
    }

    public static URI fromStringPathComponents(String bucketName, String objectName, boolean allowEmptyObjectName) {
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCSROOT;
        }
        String authority = StringPaths.validateBucketName(bucketName);
        String path = "/" + StringPaths.validateObjectName(objectName, allowEmptyObjectName);
        try {
            return new URI("gs", authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName), e);
        }
    }
}

