/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobId;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.gs.GoogleCloudStorageFileSystem;
import org.apache.hadoop.fs.gs.StringPaths;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StorageResourceId {
    private static final Logger LOG = LoggerFactory.getLogger(StorageResourceId.class);
    static final long UNKNOWN_GENERATION_ID = -1L;
    private static final Pattern GCS_PATH_PATTERN = Pattern.compile("gs://(([^/]+)(/(.+)?)?)?");
    static final StorageResourceId ROOT = new StorageResourceId();
    private final String bucketName;
    private final String objectName;
    private final String stringPath;
    private final long generationId;

    private StorageResourceId() {
        this.bucketName = null;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(this.bucketName, this.objectName);
        this.generationId = -1L;
    }

    StorageResourceId(String bucketName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(bucketName, this.objectName);
        this.generationId = -1L;
    }

    StorageResourceId(String bucketName, String objectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)objectName) ? 1 : 0) != 0, (Object)"objectName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.stringPath = StringPaths.fromComponents(bucketName, objectName);
        this.generationId = -1L;
    }

    StorageResourceId(String bucketName, String objectName, long generationId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)objectName) ? 1 : 0) != 0, (Object)"objectName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.stringPath = StringPaths.fromComponents(bucketName, objectName);
        this.generationId = generationId;
    }

    StorageResourceId(String bucketName, long generationId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        this.bucketName = bucketName;
        this.objectName = null;
        this.stringPath = StringPaths.fromComponents(bucketName, this.objectName);
        this.generationId = generationId;
    }

    boolean isStorageObject() {
        return this.bucketName != null && this.objectName != null;
    }

    boolean isBucket() {
        return this.bucketName != null && this.objectName == null;
    }

    boolean isRoot() {
        return this.bucketName == null && this.objectName == null;
    }

    boolean isDirectory() {
        return this.isRoot() || this.isBucket() || StringPaths.isDirectoryPath(this.objectName);
    }

    String getBucketName() {
        return this.bucketName;
    }

    String getObjectName() {
        return this.objectName;
    }

    long getGenerationId() {
        return this.generationId;
    }

    boolean hasGenerationId() {
        return this.generationId != -1L;
    }

    public String toString() {
        return this.stringPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageResourceId) {
            StorageResourceId other = (StorageResourceId)obj;
            return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.stringPath.hashCode();
    }

    StorageResourceId toDirectoryId() {
        if (this.isStorageObject() && !StringPaths.isDirectoryPath(this.getObjectName())) {
            return new StorageResourceId(this.getBucketName(), StringPaths.toDirectoryPath(this.getObjectName()));
        }
        return this;
    }

    static StorageResourceId fromStringPath(String path) {
        return StorageResourceId.fromStringPath(path, -1L);
    }

    static StorageResourceId fromStringPath(String path, long generationId) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Matcher matcher = GCS_PATH_PATTERN.matcher(path);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"'%s' is not a valid GCS object name.", (Object)path);
        String bucketName = matcher.group(2);
        String relativePath = matcher.group(4);
        if (bucketName == null) {
            Preconditions.checkArgument((generationId == -1L ? 1 : 0) != 0, (String)"Cannot specify generationId '%s' for root object '%s'", (long)generationId, (Object)path);
            return ROOT;
        }
        if (relativePath != null) {
            return new StorageResourceId(bucketName, relativePath, generationId);
        }
        Preconditions.checkArgument((generationId == -1L ? 1 : 0) != 0, (String)"Cannot specify generationId '%s' for bucket '%s'", (long)generationId, (Object)path);
        return new StorageResourceId(bucketName);
    }

    static StorageResourceId fromUriPath(URI path, boolean allowEmptyObjectName) {
        return StorageResourceId.fromUriPath(path, allowEmptyObjectName, -1L);
    }

    static StorageResourceId fromUriPath(URI path, boolean allowEmptyObjectName, long generationId) {
        LOG.trace("fromUriPath('{}', {})", (Object)path, (Object)allowEmptyObjectName);
        Preconditions.checkNotNull((Object)path);
        if (!"gs".equals(path.getScheme())) {
            throw new IllegalArgumentException(String.format("GCS path supports only '%s' scheme, instead got '%s' from '%s'.", "gs", path.getScheme(), path));
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCSROOT)) {
            return ROOT;
        }
        String bucketName = StringPaths.validateBucketName(path.getAuthority());
        String objectName = StringPaths.validateObjectName(path.getPath(), allowEmptyObjectName);
        return Strings.isNullOrEmpty((String)objectName) ? new StorageResourceId(bucketName, generationId) : new StorageResourceId(bucketName, objectName, generationId);
    }

    BlobId toBlobId() {
        return BlobId.of(this.bucketName, this.objectName);
    }
}

