/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import javax.annotation.Nullable;

final class ListObjectOptions {
    public static final ListObjectOptions DEFAULT = new Builder().build();
    public static final ListObjectOptions DEFAULT_FLAT_LIST = DEFAULT.builder().setDelimiter(null).build();
    private final String delimiter;
    private final boolean includePrefix;
    private final long maxResult;
    private final String fields;

    Builder builder() {
        Builder result = new Builder();
        result.fields = this.fields;
        result.delimiter = this.delimiter;
        result.maxResults = this.maxResult;
        result.includePrefix = this.includePrefix;
        return result;
    }

    private ListObjectOptions(Builder builder) {
        this.delimiter = builder.delimiter;
        this.includePrefix = builder.includePrefix;
        this.maxResult = builder.maxResults;
        this.fields = builder.fields;
    }

    @Nullable
    String getDelimiter() {
        return this.delimiter;
    }

    boolean isIncludePrefix() {
        return this.includePrefix;
    }

    long getMaxResults() {
        return this.maxResult;
    }

    @Nullable
    String getFields() {
        return this.fields;
    }

    static class Builder {
        private static final int MAX_RESULTS_UNLIMITED = -1;
        static final String OBJECT_FIELDS = String.join((CharSequence)",", "bucket", "name", "timeCreated", "updated", "generation", "metageneration", "size", "contentType", "contentEncoding", "md5Hash", "crc32c", "metadata");
        private String delimiter = "/";
        private boolean includePrefix = false;
        private long maxResults = -1L;
        private String fields = OBJECT_FIELDS;

        Builder() {
        }

        public Builder setDelimiter(String d) {
            this.delimiter = d;
            return this;
        }

        public Builder setIncludePrefix(boolean value) {
            this.includePrefix = value;
            return this;
        }

        public Builder setMaxResults(long mr) {
            this.maxResults = mr;
            return this;
        }

        public Builder setFields(String f) {
            this.fields = f;
            return this;
        }

        public ListObjectOptions build() {
            return new ListObjectOptions(this);
        }
    }
}

