/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.UserCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.gs.HadoopConfigurationProperty;
import org.apache.hadoop.fs.gs.RedactedString;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;

final class HadoopCredentialsConfiguration {
    private static final String BASE_KEY_PREFIX = "google.cloud";
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final HadoopConfigurationProperty<AuthenticationType> AUTHENTICATION_TYPE_SUFFIX = new HadoopConfigurationProperty<AuthenticationType>(".auth.type", AuthenticationType.COMPUTE_ENGINE, new String[0]);
    private static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX = new HadoopConfigurationProperty(".auth.service.account.json.keyfile");
    private static final HadoopConfigurationProperty<String> WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE_SUFFIX = new HadoopConfigurationProperty(".auth.workload.identity.federation.credential.config.file");
    private static final HadoopConfigurationProperty<String> TOKEN_SERVER_URL_SUFFIX = new HadoopConfigurationProperty(".token.server.url");
    private static final HadoopConfigurationProperty<Long> READ_TIMEOUT_SUFFIX = new HadoopConfigurationProperty<Long>(".http.read-timeout", 5000L, new String[0]);
    private static final HadoopConfigurationProperty<String> AUTH_CLIENT_ID_SUFFIX = new HadoopConfigurationProperty(".auth.client.id");
    private static final HadoopConfigurationProperty<RedactedString> AUTH_CLIENT_SECRET_SUFFIX = new HadoopConfigurationProperty(".auth.client.secret");
    private static final HadoopConfigurationProperty<RedactedString> AUTH_REFRESH_TOKEN_SUFFIX = new HadoopConfigurationProperty(".auth.refresh.token");

    private HadoopCredentialsConfiguration() {
    }

    static List<String> getConfigKeyPrefixes(String ... keyPrefixes) {
        return ImmutableList.builder().add((Object[])keyPrefixes).add((Object)BASE_KEY_PREFIX).build();
    }

    static GoogleCredentials getCredentials(Configuration config, String ... keyPrefixesVararg) throws IOException {
        List<String> keyPrefixes = HadoopCredentialsConfiguration.getConfigKeyPrefixes(keyPrefixesVararg);
        return HadoopCredentialsConfiguration.getCredentials(config, keyPrefixes);
    }

    @VisibleForTesting
    static GoogleCredentials getCredentials(Configuration config, List<String> keyPrefixes) throws IOException {
        GoogleCredentials credentials = HadoopCredentialsConfiguration.getCredentialsInternal(config, keyPrefixes);
        return credentials == null ? null : HadoopCredentialsConfiguration.configureCredentials(config, keyPrefixes, credentials);
    }

    private static GoogleCredentials getCredentialsInternal(Configuration config, List<String> keyPrefixes) throws IOException {
        AuthenticationType authenticationType = AUTHENTICATION_TYPE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1));
        switch (authenticationType) {
            case APPLICATION_DEFAULT: {
                return GoogleCredentials.getApplicationDefault();
            }
            case COMPUTE_ENGINE: {
                return ComputeEngineCredentials.newBuilder().build();
            }
            case SERVICE_ACCOUNT_JSON_KEYFILE: {
                String keyFile = SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                if (Strings.isNullOrEmpty((String)keyFile)) {
                    throw new IllegalArgumentException(String.format("Missing keyfile property ('%s') for authentication type '%s'", new Object[]{SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), authenticationType}));
                }
                try (FileInputStream fis = new FileInputStream(keyFile);){
                    ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream(fis);
                    return serviceAccountCredentials;
                }
            }
            case USER_CREDENTIALS: {
                String clientId = AUTH_CLIENT_ID_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                RedactedString clientSecret = AUTH_CLIENT_SECRET_SUFFIX.withPrefixes(keyPrefixes).getPassword(config);
                RedactedString refreshToken = AUTH_REFRESH_TOKEN_SUFFIX.withPrefixes(keyPrefixes).getPassword(config);
                return UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret.getValue()).setRefreshToken(refreshToken.getValue()).build();
            }
            case WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE: {
                String configFile = WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                try (FileInputStream fis = new FileInputStream(configFile);){
                    ExternalAccountCredentials externalAccountCredentials = ExternalAccountCredentials.fromStream(fis);
                    return externalAccountCredentials;
                }
            }
            case UNAUTHENTICATED: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
    }

    private static GoogleCredentials configureCredentials(Configuration config, List<String> keyPrefixes, GoogleCredentials credentials) {
        credentials = credentials.createScoped(CLOUD_PLATFORM_SCOPE);
        String tokenServerUrl = TOKEN_SERVER_URL_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (tokenServerUrl == null) {
            return credentials;
        }
        if (credentials instanceof ServiceAccountCredentials) {
            return ((ServiceAccountCredentials)credentials).toBuilder().setTokenServerUri(URI.create(tokenServerUrl)).build();
        }
        if (credentials instanceof UserCredentials) {
            return ((UserCredentials)credentials).toBuilder().setTokenServerUri(URI.create(tokenServerUrl)).build();
        }
        return credentials;
    }

    public static enum AuthenticationType {
        APPLICATION_DEFAULT,
        COMPUTE_ENGINE,
        SERVICE_ACCOUNT_JSON_KEYFILE,
        WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE,
        UNAUTHENTICATED,
        USER_CREDENTIALS;

    }
}

