/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.gs.RedactedString;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HadoopConfigurationProperty<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigurationProperty.class);
    private final String key;
    private final List<String> deprecatedKeys;
    private final T defaultValue;
    private List<String> keyPrefixes = ImmutableList.of((Object)"");

    HadoopConfigurationProperty(String key) {
        this(key, null, new String[0]);
    }

    HadoopConfigurationProperty(String key, T defaultValue, String ... deprecatedKeys) {
        this.key = key;
        this.deprecatedKeys = deprecatedKeys == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])deprecatedKeys);
        this.defaultValue = defaultValue;
    }

    String getKey() {
        return this.key;
    }

    T getDefault() {
        return this.defaultValue;
    }

    T get(Configuration config, BiFunction<String, T, T> getterFn) {
        String lookupKey = this.getLookupKey(config, this.key, (c, k) -> c.get(k) != null);
        return HadoopConfigurationProperty.logProperty(lookupKey, getterFn.apply(lookupKey, (String)this.defaultValue));
    }

    Duration getTimeDuration(Configuration config) {
        String lookupKey = this.getLookupKey(config, this.key, (c, k) -> c.get(k) != null);
        String defValStr = this.defaultValue == null ? null : String.valueOf(this.defaultValue);
        return HadoopConfigurationProperty.logProperty(lookupKey, Duration.ofMillis(config.getTimeDuration(lookupKey, defValStr, TimeUnit.MILLISECONDS)));
    }

    HadoopConfigurationProperty<T> withPrefixes(List<String> prefixes) {
        this.keyPrefixes = ImmutableList.copyOf(prefixes);
        return this;
    }

    RedactedString getPassword(Configuration config) {
        char[] value;
        Preconditions.checkState((this.defaultValue == null || this.defaultValue instanceof String ? 1 : 0) != 0, (Object)"Not a string property");
        String lookupKey = this.getLookupKey(config, this.key, (c, k) -> c.get(k) != null);
        try {
            value = config.getPassword(lookupKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return HadoopConfigurationProperty.logProperty(lookupKey, RedactedString.create(value == null ? (String)this.defaultValue : String.valueOf(value)));
    }

    private String getLookupKey(Configuration config, String lookupKey, BiFunction<Configuration, String, Boolean> checkFn) {
        for (String prefix : this.keyPrefixes) {
            String prefixedKey = prefix + lookupKey;
            if (checkFn.apply(config, prefixedKey).booleanValue()) {
                return prefixedKey;
            }
            for (String deprecatedKey : this.deprecatedKeys) {
                String prefixedDeprecatedKey = prefix + deprecatedKey;
                if (!checkFn.apply(config, prefixedDeprecatedKey).booleanValue()) continue;
                LOG.warn("Using deprecated key '{}', use '{}' key instead.", (Object)prefixedDeprecatedKey, (Object)prefixedKey);
                return prefixedDeprecatedKey;
            }
        }
        return this.keyPrefixes.get(0) + lookupKey;
    }

    private static <S> S logProperty(String key, S value) {
        LOG.trace("{} = {}", (Object)key, value);
        return value;
    }
}

