/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.time.Duration;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.gs.Fadvise;
import org.apache.hadoop.fs.gs.HadoopConfigurationProperty;

class GoogleHadoopFileSystemConfiguration {
    private static final Long GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT_DEFAULT = 0x800000L;
    static final HadoopConfigurationProperty<Long> BLOCK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    private static final HadoopConfigurationProperty<String> GCS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.project.id");
    static final HadoopConfigurationProperty<String> GCS_WORKING_DIRECTORY = new HadoopConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    private static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.buffer.size", 0x800000L, new String[0]);
    private static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT_DEFAULT, new String[0]);
    private static final HadoopConfigurationProperty<Fadvise> GCS_INPUT_STREAM_FADVISE = new HadoopConfigurationProperty<Fadvise>("fs.gs.inputstream.fadvise", Fadvise.RANDOM, new String[0]);
    private static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.support.gzip.encoding.enable", false, new String[0]);
    private static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.min.range.request.size", 0x200000L, new String[0]);
    private static final HadoopConfigurationProperty<Integer> GCS_FADVISE_REQUEST_TRACK_COUNT = new HadoopConfigurationProperty<Integer>("fs.gs.fadvise.request.track.count", 3, new String[0]);
    private static final HadoopConfigurationProperty<Long> GCS_REWRITE_MAX_CHUNK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.rewrite.max.chunk.size", 0x20000000L, new String[0]);
    private static final HadoopConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new HadoopConfigurationProperty("fs.gs.marker.file.pattern");
    private static final HadoopConfigurationProperty<Boolean> GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.create.items.conflict.check.enable", true, new String[0]);
    private static final HadoopConfigurationProperty<Long> GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL = new HadoopConfigurationProperty<Long>("fs.gs.outputstream.sync.min.interval", 0L, new String[0]);
    static final HadoopConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", false, new String[0]);
    private final String workingDirectory;
    private final String projectId;
    private final Configuration config;
    private Pattern fileMarkerFilePattern;
    private final int outStreamBufferSize;

    int getOutStreamBufferSize() {
        return this.outStreamBufferSize;
    }

    GoogleHadoopFileSystemConfiguration(Configuration conf) {
        this.workingDirectory = GCS_WORKING_DIRECTORY.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        this.outStreamBufferSize = Math.toIntExact(GCS_OUTPUT_STREAM_BUFFER_SIZE.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getLongBytes(arg_0, arg_1)));
        this.projectId = GCS_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        this.config = conf;
    }

    String getWorkingDirectory() {
        return this.workingDirectory;
    }

    String getProjectId() {
        return this.projectId;
    }

    long getMaxListItemsPerCall() {
        return 5000L;
    }

    Fadvise getFadvise() {
        return GCS_INPUT_STREAM_FADVISE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getEnum(arg_0, arg_1));
    }

    long getInplaceSeekLimit() {
        return GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getLongBytes(arg_0, arg_1));
    }

    int getFadviseRequestTrackCount() {
        return GCS_FADVISE_REQUEST_TRACK_COUNT.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getInt(arg_0, arg_1));
    }

    boolean isGzipEncodingSupportEnabled() {
        return GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getBoolean(arg_0, arg_1));
    }

    long getMinRangeRequestSize() {
        return GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getLongBytes(arg_0, arg_1));
    }

    long getBlockSize() {
        return BLOCK_SIZE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getLong(arg_0, arg_1));
    }

    boolean isReadExactRequestedBytesEnabled() {
        return false;
    }

    long getMaxRewriteChunkSize() {
        return GCS_REWRITE_MAX_CHUNK_SIZE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getLong(arg_0, arg_1));
    }

    Pattern getMarkerFilePattern() {
        String pattern = GCS_MARKER_FILE_PATTERN.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).get(arg_0, arg_1));
        if (pattern == null) {
            return null;
        }
        if (this.fileMarkerFilePattern == null) {
            this.fileMarkerFilePattern = Pattern.compile("^(.+/)?" + pattern + "$");
        }
        return this.fileMarkerFilePattern;
    }

    boolean isEnsureNoConflictingItems() {
        return GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getBoolean(arg_0, arg_1));
    }

    Duration getMinSyncInterval() {
        return GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL.getTimeDuration(this.config);
    }

    Configuration getConfig() {
        return this.config;
    }

    boolean isBucketDeleteEnabled() {
        return GCE_BUCKET_DELETE_ENABLE.get(this.config, (arg_0, arg_1) -> ((Configuration)this.config).getBoolean(arg_0, arg_1));
    }
}

