/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.GoogleCredentials;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.gs.ApiErrorExtractor;
import org.apache.hadoop.fs.gs.CreateFileOptions;
import org.apache.hadoop.fs.gs.FileInfo;
import org.apache.hadoop.fs.gs.GcsInstrumentation;
import org.apache.hadoop.fs.gs.GcsStatistics;
import org.apache.hadoop.fs.gs.GcsStorageStatistics;
import org.apache.hadoop.fs.gs.GoogleCloudStorageFileSystem;
import org.apache.hadoop.fs.gs.GoogleHadoopFSInputStream;
import org.apache.hadoop.fs.gs.GoogleHadoopFileSystemConfiguration;
import org.apache.hadoop.fs.gs.GoogleHadoopOutputStream;
import org.apache.hadoop.fs.gs.HadoopCredentialsConfiguration;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.apache.hadoop.fs.gs.UriPaths;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Ascii;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleHadoopFileSystem
extends FileSystem
implements IOStatisticsSource {
    public static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopFileSystem.class);
    private static final String SCHEME = "gs";
    static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final int PERMISSIONS_TO_REPORT = 700;
    private URI initUri;
    private final long defaultBlockSize = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault();
    private Path fsRoot;
    private Path workingDirectory;
    private GoogleCloudStorageFileSystem gcsFs;
    private boolean isClosed;
    private FsPermission reportedPermissions;
    private static GcsInstrumentation instrumentation = new GcsInstrumentation();
    private GcsStorageStatistics storageStatistics;
    private GoogleHadoopFileSystemConfiguration fileSystemConfiguration;

    GoogleHadoopFileSystemConfiguration getFileSystemConfiguration() {
        return this.fileSystemConfiguration;
    }

    public void initialize(URI path, Configuration config) throws IOException {
        LOG.trace("initialize(path: {}, config: {})", (Object)path, (Object)config);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config must not be null");
        Preconditions.checkArgument((path.getScheme() != null ? 1 : 0) != 0, (Object)"scheme of path must not be null");
        Preconditions.checkArgument((boolean)path.getScheme().equals(this.getScheme()), (String)"URI scheme not supported: {}", (Object)path);
        config = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)config, GoogleHadoopFileSystem.class);
        super.initialize(path, config);
        this.initUri = path;
        this.setConf(config);
        this.storageStatistics = GoogleHadoopFileSystem.createStorageStatistics(Objects.requireNonNull(this.getIOStatistics()));
        this.reportedPermissions = new FsPermission(700);
        this.initializeFsRoot();
        this.fileSystemConfiguration = new GoogleHadoopFileSystemConfiguration(config);
        this.initializeWorkingDirectory(this.fileSystemConfiguration);
        this.initializeGcsFs(this.fileSystemConfiguration);
    }

    private static GcsStorageStatistics createStorageStatistics(IOStatistics ioStatistics) {
        return (GcsStorageStatistics)GlobalStorageStatistics.INSTANCE.put("GhfsStorageStatistics", () -> new GcsStorageStatistics(ioStatistics));
    }

    private void initializeFsRoot() {
        String rootBucket = this.initUri.getAuthority();
        Preconditions.checkArgument((rootBucket != null ? 1 : 0) != 0, (String)"No bucket specified in GCS URI: {}", (Object)this.initUri);
        URI rootUri = UriPaths.fromStringPathComponents(rootBucket, null, true);
        this.fsRoot = new Path(rootUri);
        LOG.trace("Configured FS root: '{}'", (Object)this.fsRoot);
    }

    private void initializeWorkingDirectory(GoogleHadoopFileSystemConfiguration config) {
        String configWorkingDirectory = config.getWorkingDirectory();
        if (Strings.isNullOrEmpty((String)configWorkingDirectory)) {
            LOG.warn("No working directory configured, using default: '{}'", (Object)this.workingDirectory);
        }
        this.setWorkingDirectory(Strings.isNullOrEmpty((String)configWorkingDirectory) ? this.fsRoot : new Path(configWorkingDirectory));
        LOG.trace("Configured working directory: {} = {}", (Object)GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey(), (Object)this.getWorkingDirectory());
    }

    private synchronized void initializeGcsFs(GoogleHadoopFileSystemConfiguration config) throws IOException {
        this.gcsFs = this.createGcsFs(config);
    }

    private GoogleCloudStorageFileSystem createGcsFs(GoogleHadoopFileSystemConfiguration config) throws IOException {
        GoogleCredentials credentials = this.getCredentials(config);
        return new GoogleCloudStorageFileSystem(config, credentials);
    }

    private GoogleCredentials getCredentials(GoogleHadoopFileSystemConfiguration config) throws IOException {
        return GoogleHadoopFileSystem.getCredentials(config, "fs.gs");
    }

    static GoogleCredentials getCredentials(GoogleHadoopFileSystemConfiguration config, String ... keyPrefixesVararg) throws IOException {
        return HadoopCredentialsConfiguration.getCredentials(config.getConfig(), keyPrefixesVararg);
    }

    protected void checkPath(Path path) {
        LOG.trace("checkPath(path: {})", (Object)path);
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException(String.format("Wrong scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme()));
        }
        String bucket = uri.getAuthority();
        String rootBucket = this.fsRoot.toUri().getAuthority();
        if (bucket == null || bucket.equals(rootBucket)) {
            return;
        }
        throw new IllegalArgumentException(String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, rootBucket));
    }

    Path getHadoopPath(URI gcsPath) {
        LOG.trace("getHadoopPath(gcsPath: {})", (Object)gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.fsRoot))) {
            return this.fsRoot;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(gcsPath, true);
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (String)"Missing authority in gcsPath '{}'", (Object)gcsPath);
        String rootBucket = this.fsRoot.toUri().getAuthority();
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(rootBucket), (String)"Authority of URI '{}' doesn't match root bucket '{}'", (Object)resourceId.getBucketName(), (Object)rootBucket);
        Path hadoopPath = new Path(this.fsRoot, new Path(null, null, resourceId.getObjectName()));
        LOG.trace("getHadoopPath(gcsPath: {}): {}", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    URI getGcsPath(Path hadoopPath) {
        LOG.trace("getGcsPath(hadoopPath: {})", (Object)hadoopPath);
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        String rootBucket = this.fsRoot.toUri().getAuthority();
        URI gcsPath = UriPaths.fromStringPathComponents(rootBucket, objectName, true);
        LOG.trace("getGcsPath(hadoopPath: {}): {}", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        return (FSDataInputStream)this.runOperation(GcsStatistics.INVOCATION_OPEN, () -> {
            LOG.trace("open({})", (Object)hadoopPath);
            URI gcsPath = this.getGcsPath(hadoopPath);
            return new FSDataInputStream((InputStream)((Object)GoogleHadoopFSInputStream.create(this, gcsPath, this.statistics)));
        }, String.format("open(%s)", hadoopPath));
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return (FSDataOutputStream)this.runOperation(GcsStatistics.INVOCATION_CREATE, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0, (String)"replication must be a positive integer: %s", (int)replication);
            Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"blockSize must be a positive integer: %s", (long)blockSize);
            this.checkOpen();
            LOG.trace("create(hadoopPath: {}, overwrite: {}, bufferSize: {} [ignored])", new Object[]{hadoopPath, overwrite, bufferSize});
            CreateFileOptions.WriteMode writeMode = overwrite ? CreateFileOptions.WriteMode.OVERWRITE : CreateFileOptions.WriteMode.CREATE_NEW;
            CreateFileOptions fileOptions = CreateFileOptions.builder().setWriteMode(writeMode).build();
            return new FSDataOutputStream((OutputStream)new GoogleHadoopOutputStream(this, this.getGcsPath(hadoopPath), fileOptions, this.statistics), this.statistics);
        }, String.format("create(%s, %s)", hadoopPath, overwrite));
    }

    public FSDataOutputStream createNonRecursive(Path hadoopPath, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        URI gcsPath = this.getGcsPath((Path)Preconditions.checkNotNull((Object)hadoopPath, (Object)"hadoopPath must not be null"));
        URI parentGcsPath = UriPaths.getParentPath(gcsPath);
        if (!this.getGcsFs().getFileInfo(parentGcsPath).exists()) {
            throw new FileNotFoundException(String.format("Can not create '%s' file, because parent folder does not exist: %s", gcsPath, parentGcsPath));
        }
        return this.create(hadoopPath, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        LOG.trace("append(hadoopPath: {}, bufferSize: {} [ignored])", (Object)hadoopPath, (Object)bufferSize);
        URI filePath = this.getGcsPath(hadoopPath);
        return new FSDataOutputStream((OutputStream)new GoogleHadoopOutputStream(this, filePath, CreateFileOptions.builder().setWriteMode(CreateFileOptions.WriteMode.APPEND).build(), this.statistics), this.statistics);
    }

    public void concat(Path tgt, Path[] srcs) throws IOException {
        LOG.trace("concat(tgt: {}, srcs.length: {})", (Object)tgt, (Object)srcs.length);
        Preconditions.checkArgument((srcs.length > 0 ? 1 : 0) != 0, (Object)"srcs must have at least one source");
        URI tgtPath = this.getGcsPath(tgt);
        List srcPaths = (List)Arrays.stream(srcs).map(this::getGcsPath).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!srcPaths.contains(tgtPath) ? 1 : 0) != 0, (Object)"target must not be contained in sources");
        List partitions = Lists.partition((List)srcPaths, (int)31);
        LOG.trace("concat(tgt: {}, {} partitions: {})", new Object[]{tgt, partitions.size(), partitions});
        for (List partition : partitions) {
            ArrayList sources = Lists.newArrayList((Object[])new URI[]{tgtPath});
            sources.addAll(partition);
            this.getGcsFs().compose(sources, tgtPath, CreateFileOptions.DEFAULT.getContentType());
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return (Boolean)this.runOperation(GcsStatistics.INVOCATION_RENAME, () -> {
            LOG.trace("rename({}, {})", (Object)src, (Object)dst);
            Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
            Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
            if (this.makeQualified(src).equals((Object)this.fsRoot)) {
                LOG.trace("rename(src: {}, dst: {}): false [src is a root]", (Object)src, (Object)dst);
                return false;
            }
            try {
                this.checkOpen();
                URI srcPath = this.getGcsPath(src);
                URI dstPath = this.getGcsPath(dst);
                this.getGcsFs().rename(srcPath, dstPath);
                LOG.trace("rename(src: {}, dst: {}): true", (Object)src, (Object)dst);
            }
            catch (IOException e) {
                if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                    throw e;
                }
                LOG.trace("rename(src: {}, dst: {}): false [failed]", new Object[]{src, dst, e});
                return false;
            }
            return true;
        }, String.format("rename(%s, %s)", src, dst));
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        return (Boolean)this.runOperation(GcsStatistics.INVOCATION_DELETE, () -> {
            LOG.trace("delete({}, {})", (Object)hadoopPath, (Object)recursive);
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            URI gcsPath = this.getGcsPath(hadoopPath);
            try {
                this.getGcsFs().delete(gcsPath, recursive);
            }
            catch (DirectoryNotEmptyException e) {
                throw e;
            }
            catch (IOException e) {
                if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                    throw e;
                }
                LOG.trace("delete(hadoopPath: {}, recursive: {}): false [failed]", new Object[]{hadoopPath, recursive, e});
                return false;
            }
            LOG.trace("delete(hadoopPath: {}, recursive: {}): true", (Object)hadoopPath, (Object)recursive);
            return true;
        }, String.format("delete(%s,%s", hadoopPath, recursive));
    }

    private <B> B runOperation(GcsStatistics stat, CallableRaisingIOE<B> operation, String context) throws IOException {
        LOG.trace("{}({})", (Object)stat, (Object)context);
        return (B)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation.getIOStatistics(), (String)stat.getSymbol(), operation);
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        return (FileStatus[])this.runOperation(GcsStatistics.INVOCATION_LIST_STATUS, () -> {
            ArrayList<FileStatus> status;
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            LOG.trace("listStatus(hadoopPath: {})", (Object)hadoopPath);
            URI gcsPath = this.getGcsPath(hadoopPath);
            try {
                List<FileInfo> fileInfos = this.getGcsFs().listDirectory(gcsPath);
                status = new ArrayList<FileStatus>(fileInfos.size());
                String userName = GoogleHadoopFileSystem.getUgiUserName();
                for (FileInfo fileInfo : fileInfos) {
                    status.add(this.getFileStatus(fileInfo, userName));
                }
            }
            catch (FileNotFoundException fnfe) {
                throw (FileNotFoundException)new FileNotFoundException(String.format("listStatus(hadoopPath: %s): '%s' does not exist.", hadoopPath, gcsPath)).initCause(fnfe);
            }
            return status.toArray(new FileStatus[0]);
        }, String.format("listStatus(%s", hadoopPath));
    }

    public Path makeQualified(Path path) {
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState(("".equals(uri.getPath()) || qualifiedPath.isAbsolute() ? 1 : 0) != 0, (String)"Path '{}' must be fully qualified.", (Object)qualifiedPath);
        String upath = uri.getPath();
        int i = 0;
        while (upath.startsWith("/../", i)) {
            i += 3;
        }
        Path result = i == upath.length() || upath.substring(i).equals("/..") ? new Path(uri.getScheme(), uri.getAuthority(), "/") : (i == 0 ? qualifiedPath : new Path(uri.getScheme(), uri.getAuthority(), upath.substring(i)));
        LOG.trace("makeQualified(path: {}): {}", (Object)path, (Object)result);
        return result;
    }

    public URI getUri() {
        return this.fsRoot.toUri();
    }

    protected int getDefaultPort() {
        int result = -1;
        LOG.trace("getDefaultPort(): {}", (Object)result);
        return result;
    }

    public boolean hasPathCapability(Path path, String capability) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)capability) ? 1 : 0) != 0, (String)"capability must not be null or empty string for {}", (Object)path);
        switch (Ascii.toLowerCase((String)capability)) {
            case "fs.capability.paths.append": 
            case "fs.capability.paths.concat": {
                return true;
            }
        }
        return false;
    }

    public Path getWorkingDirectory() {
        LOG.trace("getWorkingDirectory(): {}", (Object)this.workingDirectory);
        return this.workingDirectory;
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        return (Boolean)this.runOperation(GcsStatistics.INVOCATION_MKDIRS, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            LOG.trace("mkdirs(hadoopPath: {}, permission: {}): true", (Object)hadoopPath, (Object)permission);
            this.checkOpen();
            URI gcsPath = this.getGcsPath(hadoopPath);
            try {
                this.getGcsFs().mkdirs(gcsPath);
            }
            catch (java.nio.file.FileAlreadyExistsException faee) {
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("mkdirs(hadoopPath: %s, permission: %s): failed", hadoopPath, permission)).initCause((Throwable)faee);
            }
            return true;
        }, String.format("mkdirs(%s)", hadoopPath));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return (FileStatus)this.runOperation(GcsStatistics.INVOCATION_GET_FILE_STATUS, () -> {
            Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
            this.checkOpen();
            URI gcsPath = this.getGcsPath(path);
            FileInfo fileInfo = this.getGcsFs().getFileInfo(gcsPath);
            if (!fileInfo.exists()) {
                throw new FileNotFoundException(String.format("%s not found: %s", fileInfo.isDirectory() ? "Directory" : "File", path));
            }
            String userName = GoogleHadoopFileSystem.getUgiUserName();
            return this.getFileStatus(fileInfo, userName);
        }, String.format("getFileStatus(%s)", path));
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.fsRoot, "user/" + System.getProperty("user.name"));
        LOG.trace("getHomeDirectory(): {}", (Object)result);
        return result;
    }

    public String getCanonicalServiceName() {
        return null;
    }

    GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsFs;
    }

    private void checkOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    public void close() throws IOException {
        LOG.trace("close()");
        if (this.isClosed) {
            return;
        }
        super.close();
        this.getGcsFs().close();
        this.isClosed = true;
    }

    public long getUsed() throws IOException {
        long result = super.getUsed();
        LOG.trace("getUsed(): {}", (Object)result);
        return result;
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        URI gcsPath = UriPaths.toDirectory(this.getGcsPath(hadoopPath));
        this.workingDirectory = this.getHadoopPath(gcsPath);
        LOG.trace("setWorkingDirectory(hadoopPath: {}): {}", (Object)hadoopPath, (Object)this.workingDirectory);
    }

    public IOStatistics getIOStatistics() {
        return instrumentation != null ? instrumentation.getIOStatistics() : null;
    }

    public GcsStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    private static String getUgiUserName() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return ugi.getShortUserName();
    }

    private FileStatus getFileStatus(FileInfo fileInfo, String userName) {
        Preconditions.checkNotNull((Object)fileInfo, (Object)"fileInfo should not be null");
        FileStatus status = new FileStatus(fileInfo.getSize(), fileInfo.isDirectory(), 3, this.defaultBlockSize, fileInfo.getModificationTime(), fileInfo.getModificationTime(), this.reportedPermissions, userName, userName, this.getHadoopPath(fileInfo.getPath()));
        LOG.trace("FileStatus(path: {}, userName: {}): {}", new Object[]{fileInfo.getPath(), userName, status});
        return status;
    }
}

