/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.gs.FileInfo;
import org.apache.hadoop.fs.gs.GoogleCloudStorageFileSystem;
import org.apache.hadoop.fs.gs.GoogleHadoopFileSystem;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GoogleHadoopFSInputStream
extends FSInputStream {
    public static final Logger LOG = LoggerFactory.getLogger(GoogleHadoopFSInputStream.class);
    private final byte[] singleReadBuf = new byte[1];
    private final URI gcsPath;
    private final SeekableByteChannel channel;
    private long totalBytesRead = 0L;
    private volatile boolean closed;
    private final FileSystem.Statistics statistics;

    static GoogleHadoopFSInputStream create(GoogleHadoopFileSystem ghfs, URI gcsPath, FileSystem.Statistics statistics) throws IOException {
        LOG.trace("create(gcsPath: {})", (Object)gcsPath);
        GoogleCloudStorageFileSystem gcsFs = ghfs.getGcsFs();
        FileInfo fileInfo = gcsFs.getFileInfoObject(gcsPath);
        SeekableByteChannel channel = gcsFs.open(fileInfo, ghfs.getFileSystemConfiguration());
        return new GoogleHadoopFSInputStream(gcsPath, channel, statistics);
    }

    private GoogleHadoopFSInputStream(URI gcsPath, SeekableByteChannel channel, FileSystem.Statistics statistics) {
        LOG.trace("GoogleHadoopFSInputStream(gcsPath: {})", (Object)gcsPath);
        this.gcsPath = gcsPath;
        this.channel = channel;
        this.statistics = statistics;
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        int numRead = this.read(this.singleReadBuf, 0, 1);
        Preconditions.checkState((numRead == -1 || numRead == 1 ? 1 : 0) != 0, (String)"Read %s bytes using single-byte buffer for path %s ending in position %s", (Object)numRead, (Object)this.gcsPath, (Object)this.channel.position());
        return numRead > 0 ? this.singleReadBuf[0] & 0xFF : numRead;
    }

    public synchronized int read(@Nonnull byte[] buf, int offset, int length) throws IOException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)buf, (Object)"buf must not be null");
        if (offset < 0 || length < 0 || length > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
        if (numRead > 0) {
            this.totalBytesRead += (long)numRead;
            this.statistics.incrementBytesRead((long)numRead);
            this.statistics.incrementReadOps(1);
        }
        return numRead;
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkNotClosed();
        LOG.trace("seek({})", (Object)pos);
        try {
            this.channel.position(pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            LOG.trace("close(): {}", (Object)this.gcsPath);
            try {
                if (this.channel != null) {
                    LOG.trace("Closing '{}' file with {} total bytes read", (Object)this.gcsPath, (Object)this.totalBytesRead);
                    this.channel.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Error while closing underneath read channel resources for path: {}", (Object)this.gcsPath, (Object)e);
            }
        }
    }

    public synchronized long getPos() throws IOException {
        this.checkNotClosed();
        long pos = this.channel.position();
        LOG.trace("getPos(): {}", (Object)pos);
        return pos;
    }

    public boolean seekToNewSource(long targetPos) {
        LOG.trace("seekToNewSource({}): false", (Object)targetPos);
        return false;
    }

    public int available() throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        return super.available();
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.gcsPath + ": Stream is closed!");
        }
    }
}

