/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.apache.hadoop.fs.gs.VerificationAttributes;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

final class GoogleCloudStorageItemInfo {
    public static final GoogleCloudStorageItemInfo ROOT_INFO = new GoogleCloudStorageItemInfo(StorageResourceId.ROOT, 0L, 0L, 0L, null, null, null, null, null, 0L, 0L, null);
    private final StorageResourceId resourceId;
    private final long creationTime;
    private final long modificationTime;
    private final long size;
    private final String location;
    private final String storageClass;
    private final String contentType;
    private final String contentEncoding;
    private final Map<String, byte[]> metadata;
    private final long contentGeneration;
    private final long metaGeneration;
    private final VerificationAttributes verificationAttributes;

    static GoogleCloudStorageItemInfo createBucket(StorageResourceId resourceId, long creationTime, long modificationTime, String location, String storageClass) {
        Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId must not be null");
        Preconditions.checkArgument((boolean)resourceId.isBucket(), (String)"expected bucket but got '%s'", (Object)resourceId);
        return new GoogleCloudStorageItemInfo(resourceId, creationTime, modificationTime, 0L, location, storageClass, null, null, null, 0L, 0L, null);
    }

    static GoogleCloudStorageItemInfo createObject(StorageResourceId resourceId, long creationTime, long modificationTime, long size, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration, VerificationAttributes verificationAttributes) {
        Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId must not be null");
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (String)"expected object or directory but got '%s'", (Object)resourceId);
        Preconditions.checkArgument((!resourceId.isBucket() ? 1 : 0) != 0, (String)"expected object or directory but got '%s'", (Object)resourceId);
        return new GoogleCloudStorageItemInfo(resourceId, creationTime, modificationTime, size, null, null, contentType, contentEncoding, metadata, contentGeneration, metaGeneration, verificationAttributes);
    }

    static GoogleCloudStorageItemInfo createInferredDirectory(StorageResourceId resourceId) {
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, 0L, null, null, null, null, null, 0L, 0L, null);
    }

    static GoogleCloudStorageItemInfo createNotFound(StorageResourceId resourceId) {
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, -1L, null, null, null, null, null, 0L, 0L, null);
    }

    private GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long modificationTime, long size, String location, String storageClass, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration, VerificationAttributes verificationAttributes) {
        this.resourceId = (StorageResourceId)Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId must not be null");
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.size = size;
        this.location = location;
        this.storageClass = storageClass;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.contentGeneration = contentGeneration;
        this.metaGeneration = metaGeneration;
        this.verificationAttributes = verificationAttributes;
    }

    String getBucketName() {
        return this.resourceId.getBucketName();
    }

    String getObjectName() {
        return this.resourceId.getObjectName();
    }

    StorageResourceId getResourceId() {
        return this.resourceId;
    }

    long getCreationTime() {
        return this.creationTime;
    }

    long getModificationTime() {
        return this.modificationTime;
    }

    long getSize() {
        return this.size;
    }

    String getLocation() {
        return this.location;
    }

    String getStorageClass() {
        return this.storageClass;
    }

    String getContentType() {
        return this.contentType;
    }

    String getContentEncoding() {
        return this.contentEncoding;
    }

    Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    boolean isBucket() {
        return this.resourceId.isBucket();
    }

    boolean isRoot() {
        return this.resourceId.isRoot();
    }

    boolean isGlobalRoot() {
        return this.isRoot() && this.exists();
    }

    boolean isDirectory() {
        return this.isGlobalRoot() || this.isBucket() || this.resourceId.isDirectory();
    }

    boolean isInferredDirectory() {
        return this.creationTime == 0L && this.modificationTime == 0L && this.size == 0L && this.contentGeneration == 0L && this.metaGeneration == 0L;
    }

    long getContentGeneration() {
        return this.contentGeneration;
    }

    long getMetaGeneration() {
        return this.metaGeneration;
    }

    VerificationAttributes getVerificationAttributes() {
        return this.verificationAttributes;
    }

    boolean exists() {
        return this.size >= 0L;
    }

    @VisibleForTesting
    public boolean metadataEquals(Map<String, byte[]> otherMetadata) {
        if (this.metadata == otherMetadata) {
            return true;
        }
        if (this.metadata == null || otherMetadata == null) {
            return false;
        }
        if (!this.metadata.keySet().equals(otherMetadata.keySet())) {
            return false;
        }
        for (Map.Entry<String, byte[]> metadataEntry : this.metadata.entrySet()) {
            if (Arrays.equals(metadataEntry.getValue(), otherMetadata.get(metadataEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.exists() ? String.format("%s: created on: %s", this.resourceId, Instant.ofEpochMilli(this.creationTime)) : String.format("%s: exists: no", this.resourceId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GoogleCloudStorageItemInfo) {
            GoogleCloudStorageItemInfo other = (GoogleCloudStorageItemInfo)obj;
            return this.resourceId.equals(other.resourceId) && this.creationTime == other.creationTime && this.modificationTime == other.modificationTime && this.size == other.size && Objects.equals(this.location, other.location) && Objects.equals(this.storageClass, other.storageClass) && Objects.equals(this.verificationAttributes, other.verificationAttributes) && this.metaGeneration == other.metaGeneration && this.contentGeneration == other.contentGeneration && this.metadataEquals(other.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resourceId.hashCode();
        result = 31 * result + (int)this.creationTime;
        result = 31 * result + (int)this.modificationTime;
        result = 31 * result + (int)this.size;
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.storageClass);
        result = 31 * result + Objects.hashCode(this.verificationAttributes);
        result = 31 * result + (int)this.metaGeneration;
        result = 31 * result + (int)this.contentGeneration;
        result = 31 * result + this.metadata.entrySet().stream().mapToInt(e -> Objects.hash(e.getKey()) + Arrays.hashCode((byte[])e.getValue())).sum();
        return result;
    }
}

