/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.apache.hadoop.fs.gs.StringPaths;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;

final class GoogleCloudStorageExceptions {
    private GoogleCloudStorageExceptions() {
    }

    static FileNotFoundException createFileNotFoundException(String bucketName, String objectName, @Nullable IOException cause) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        FileNotFoundException fileNotFoundException = new FileNotFoundException(String.format("Item not found: '%s'. Note, it is possible that the live version is still available but the requested generation is deleted.", StringPaths.fromComponents(bucketName, Strings.nullToEmpty((String)objectName))));
        if (cause != null) {
            fileNotFoundException.initCause(cause);
        }
        return fileNotFoundException;
    }

    static FileNotFoundException createFileNotFoundException(StorageResourceId resourceId, @Nullable IOException cause) {
        return GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), cause);
    }

    public static IOException createCompositeException(Collection<IOException> innerExceptions) {
        Preconditions.checkArgument((innerExceptions != null && !innerExceptions.isEmpty() ? 1 : 0) != 0, (String)"innerExceptions (%s) must be not null and contain at least one element", innerExceptions);
        Iterator<IOException> innerExceptionIterator = innerExceptions.iterator();
        if (innerExceptions.size() == 1) {
            return innerExceptionIterator.next();
        }
        IOException combined = new IOException("Multiple IOExceptions.");
        while (innerExceptionIterator.hasNext()) {
            combined.addSuppressed(innerExceptionIterator.next());
        }
        return combined;
    }
}

