/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.apache.hadoop.fs.gs.CreateFileOptions;
import org.apache.hadoop.fs.gs.GoogleCloudStorageItemInfo;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleCloudStorageClientWriteChannel
implements WritableByteChannel {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCloudStorageClientWriteChannel.class);
    private final StorageResourceId resourceId;
    private WritableByteChannel writableByteChannel;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageClientWriteChannel(Storage storage, StorageResourceId resourceId, CreateFileOptions createOptions) throws IOException {
        this.resourceId = resourceId;
        BlobWriteSession blobWriteSession = GoogleCloudStorageClientWriteChannel.getBlobWriteSession(storage, resourceId, createOptions);
        try {
            this.writableByteChannel = blobWriteSession.open();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    private static BlobInfo getBlobInfo(StorageResourceId resourceId, CreateFileOptions createOptions) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(resourceId.getBucketName(), resourceId.getObjectName(), resourceId.getGenerationId())).setContentType(createOptions.getContentType()).build();
        return blobInfo;
    }

    private static BlobWriteSession getBlobWriteSession(Storage storage, StorageResourceId resourceId, CreateFileOptions createOptions) {
        return storage.blobWriteSession(GoogleCloudStorageClientWriteChannel.getBlobInfo(resourceId, createOptions), GoogleCloudStorageClientWriteChannel.generateWriteOptions(createOptions));
    }

    private static Storage.BlobWriteOption[] generateWriteOptions(CreateFileOptions createOptions) {
        ArrayList<Storage.BlobWriteOption> blobWriteOptions = new ArrayList<Storage.BlobWriteOption>();
        blobWriteOptions.add(Storage.BlobWriteOption.disableGzipContent());
        blobWriteOptions.add(Storage.BlobWriteOption.generationMatch());
        return blobWriteOptions.toArray(new Storage.BlobWriteOption[blobWriteOptions.size()]);
    }

    @Override
    public boolean isOpen() {
        return this.writableByteChannel != null && this.writableByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isOpen()) {
                return;
            }
            this.writableByteChannel.close();
        }
        catch (Exception e) {
            throw new IOException(String.format("Upload failed for '%s'. reason=%s", this.resourceId, e.getMessage()), e);
        }
        finally {
            this.writableByteChannel = null;
        }
    }

    private int writeInternal(ByteBuffer byteBuffer) throws IOException {
        int bytesWritten = this.writableByteChannel.write(byteBuffer);
        LOG.trace("{} bytes were written out of provided buffer of capacity {}", (Object)bytesWritten, (Object)byteBuffer.limit());
        return bytesWritten;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.writeInternal(src);
    }
}

