/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.StorageStatisticsFromIOStatistics;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GcsStorageStatistics
extends StorageStatisticsFromIOStatistics {
    static final String NAME = "GhfsStorageStatistics";

    GcsStorageStatistics(IOStatistics ioStatistics) {
        super(NAME, "gs", ioStatistics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.getLongStatistics();
        while (it.hasNext()) {
            StorageStatistics.LongStatistic statistic = (StorageStatistics.LongStatistic)it.next();
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s=%s", statistic.getName(), statistic.getValue()));
        }
        return String.format("[%s]", sb);
    }
}

