/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.gs.StringPaths;

final class GcsListOperation {
    private static final int ALL = 0;
    private final Storage.BlobListOption[] listOptions;
    private final String bucketName;
    private final Storage storage;
    private final int limit;

    private GcsListOperation(Builder builder) {
        this.listOptions = builder.blobListOptions.toArray(new Storage.BlobListOption[builder.blobListOptions.size()]);
        this.bucketName = builder.bucket;
        this.storage = builder.storage;
        this.limit = builder.limit;
    }

    public List<Blob> execute() {
        ArrayList<Blob> result = new ArrayList<Blob>();
        for (Blob blob : this.storage.list(this.bucketName, this.listOptions).iterateAll()) {
            result.add(blob);
            if (this.limit == 0 || result.size() < this.limit) continue;
            break;
        }
        return result;
    }

    static class Builder {
        private final ArrayList<Storage.BlobListOption> blobListOptions = new ArrayList();
        private String prefix;
        private final String bucket;
        private final Storage storage;
        private int limit = 0;

        Builder(String bucketName, String thePrefix, Storage storage) {
            this.storage = storage;
            this.bucket = bucketName;
            this.prefix = thePrefix;
        }

        Builder forRecursiveListing() {
            return this;
        }

        GcsListOperation build() {
            if (this.prefix != null) {
                this.blobListOptions.add(Storage.BlobListOption.prefix(this.prefix));
            }
            return new GcsListOperation(this);
        }

        Builder forCurrentDirectoryListing() {
            this.blobListOptions.add(Storage.BlobListOption.currentDirectory());
            this.blobListOptions.add(Storage.BlobListOption.includeTrailingDelimiter());
            return this;
        }

        Builder forImplicitDirectoryCheck() {
            this.limit = 1;
            if (this.prefix != null) {
                this.prefix = StringPaths.toDirectoryPath(this.prefix);
            }
            this.blobListOptions.add(Storage.BlobListOption.pageSize(1L));
            this.forCurrentDirectoryListing();
            return this;
        }
    }
}

