/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.gs.GcsStatistics;
import org.apache.hadoop.fs.gs.StatisticTypeEnum;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;

class GcsInstrumentation
implements Closeable,
IOStatisticsSource {
    private final IOStatisticsStore instanceIOStatistics;

    GcsInstrumentation() {
        IOStatisticsStoreBuilder storeBuilder = IOStatisticsBinding.iostatisticsStore();
        EnumSet.allOf(GcsStatistics.class).stream().filter(statistic -> statistic.getType() == StatisticTypeEnum.TYPE_COUNTER).forEach(stat -> storeBuilder.withCounters(new String[]{stat.getSymbol()}));
        EnumSet.allOf(GcsStatistics.class).stream().filter(statistic -> statistic.getType() == StatisticTypeEnum.TYPE_DURATION).forEach(stat -> storeBuilder.withDurationTracking(new String[]{stat.getSymbol()}));
        this.instanceIOStatistics = storeBuilder.build();
    }

    @Override
    public void close() throws IOException {
    }

    public IOStatisticsStore getIOStatistics() {
        return this.instanceIOStatistics;
    }
}

