/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.gs.GoogleCloudStorageFileSystem;
import org.apache.hadoop.fs.gs.GoogleCloudStorageItemInfo;
import org.apache.hadoop.fs.gs.UriPaths;
import org.apache.hadoop.fs.gs.VerificationAttributes;

final class FileInfo {
    static final FileInfo ROOT_INFO = new FileInfo(GoogleCloudStorageFileSystem.GCSROOT, GoogleCloudStorageItemInfo.ROOT_INFO);
    private final URI path;
    private final GoogleCloudStorageItemInfo itemInfo;

    private FileInfo(URI path, GoogleCloudStorageItemInfo itemInfo) {
        this.itemInfo = itemInfo;
        this.path = path;
    }

    URI getPath() {
        return this.path;
    }

    boolean isDirectory() {
        return this.itemInfo.isDirectory();
    }

    boolean isInferredDirectory() {
        return this.itemInfo.isInferredDirectory();
    }

    boolean isGlobalRoot() {
        return this.itemInfo.isGlobalRoot();
    }

    long getCreationTime() {
        return this.itemInfo.getCreationTime();
    }

    long getSize() {
        return this.itemInfo.getSize();
    }

    long getModificationTime() {
        return this.itemInfo.getModificationTime();
    }

    Map<String, byte[]> getAttributes() {
        return this.itemInfo.getMetadata();
    }

    boolean exists() {
        return this.itemInfo.exists();
    }

    byte[] getCrc32cChecksum() {
        VerificationAttributes verificationAttributes = this.itemInfo.getVerificationAttributes();
        return verificationAttributes == null ? null : verificationAttributes.getCrc32c();
    }

    byte[] getMd5Checksum() {
        VerificationAttributes verificationAttributes = this.itemInfo.getVerificationAttributes();
        return verificationAttributes == null ? null : verificationAttributes.getMd5hash();
    }

    GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public String toString() {
        return this.getPath() + (String)(this.exists() ? ": created on: " + Instant.ofEpochMilli(this.getCreationTime()) : ": exists: no");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return Objects.equals(this.path, fileInfo.path) && Objects.equals(this.itemInfo, fileInfo.itemInfo);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.itemInfo);
    }

    static FileInfo fromItemInfo(GoogleCloudStorageItemInfo itemInfo) {
        if (itemInfo.isRoot()) {
            return ROOT_INFO;
        }
        URI path = UriPaths.fromResourceId(itemInfo.getResourceId(), true);
        return new FileInfo(path, itemInfo);
    }

    static List<FileInfo> fromItemInfos(List<GoogleCloudStorageItemInfo> itemInfos) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(itemInfos.size());
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            fileInfos.add(FileInfo.fromItemInfo(itemInfo));
        }
        return fileInfos;
    }
}

