/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import org.apache.hadoop.fs.gs.Fadvise;
import org.apache.hadoop.fs.gs.GoogleHadoopFileSystemConfiguration;
import org.apache.hadoop.fs.gs.StorageResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileAccessPatternManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileAccessPatternManager.class);
    private final StorageResourceId resourceId;
    private final GoogleHadoopFileSystemConfiguration config;
    private final Fadvise fadvise;
    private boolean isPatternOverriden = false;
    private boolean randomAccess;
    private boolean isBackwardSeekRequested = false;
    private boolean isForwardSeekRequested = false;
    private long lastServedIndex = -1L;
    private int consecutiveSequentialCount = 0;

    FileAccessPatternManager(StorageResourceId resourceId, GoogleHadoopFileSystemConfiguration configuration) {
        this.resourceId = resourceId;
        this.config = configuration;
        this.fadvise = this.config.getFadvise();
        this.randomAccess = this.fadvise == Fadvise.AUTO_RANDOM || this.fadvise == Fadvise.RANDOM;
    }

    void updateLastServedIndex(long position) {
        this.lastServedIndex = position;
    }

    boolean shouldAdaptToRandomAccess() {
        return this.randomAccess;
    }

    void updateAccessPattern(long currentPosition) {
        if (this.isPatternOverriden) {
            LOG.trace("Will bypass computing access pattern as it's overriden for resource :{}", (Object)this.resourceId);
            return;
        }
        this.updateSeekFlags(currentPosition);
        if (this.fadvise == Fadvise.AUTO_RANDOM) {
            if (this.randomAccess) {
                if (this.shouldAdaptToSequential(currentPosition)) {
                    this.unsetRandomAccess();
                }
            } else if (this.shouldAdaptToRandomAccess(currentPosition)) {
                this.setRandomAccess();
            }
        } else if (this.fadvise == Fadvise.AUTO && this.shouldAdaptToRandomAccess(currentPosition)) {
            this.setRandomAccess();
        }
    }

    void overrideAccessPattern(boolean isRandomPattern) {
        this.isPatternOverriden = true;
        this.randomAccess = isRandomPattern;
        LOG.trace("Overriding the random access pattern to %s for fadvise:%s for resource: %s ", new Object[]{isRandomPattern, this.fadvise, this.resourceId});
    }

    private boolean shouldAdaptToSequential(long currentPosition) {
        if (this.lastServedIndex != -1L) {
            long distance = currentPosition - this.lastServedIndex;
            this.consecutiveSequentialCount = distance < 0L || distance > this.config.getInplaceSeekLimit() ? 0 : ++this.consecutiveSequentialCount;
        }
        if (!this.shouldDetectSequentialAccess()) {
            return false;
        }
        if (this.consecutiveSequentialCount < this.config.getFadviseRequestTrackCount()) {
            return false;
        }
        LOG.trace("Detected {} consecutive read request within distance threshold {} with fadvise: {} switching to sequential IO for '{}'", new Object[]{this.consecutiveSequentialCount, this.config.getInplaceSeekLimit(), this.fadvise, this.resourceId});
        return true;
    }

    private boolean shouldAdaptToRandomAccess(long currentPosition) {
        if (!this.shouldDetectRandomAccess()) {
            return false;
        }
        if (this.lastServedIndex == -1L) {
            return false;
        }
        if (this.isBackwardOrForwardSeekRequested()) {
            LOG.trace("Backward or forward seek requested, isBackwardSeek: {}, isForwardSeek:{} for '{}'", new Object[]{this.isBackwardSeekRequested, this.isForwardSeekRequested, this.resourceId});
            return true;
        }
        return false;
    }

    private boolean shouldDetectSequentialAccess() {
        return this.randomAccess && !this.isBackwardOrForwardSeekRequested() && this.consecutiveSequentialCount >= this.config.getFadviseRequestTrackCount() && this.fadvise == Fadvise.AUTO_RANDOM;
    }

    private boolean shouldDetectRandomAccess() {
        return !this.randomAccess && (this.fadvise == Fadvise.AUTO || this.fadvise == Fadvise.AUTO_RANDOM);
    }

    private void setRandomAccess() {
        this.randomAccess = true;
    }

    private void unsetRandomAccess() {
        this.randomAccess = false;
    }

    private boolean isBackwardOrForwardSeekRequested() {
        return this.isBackwardSeekRequested || this.isForwardSeekRequested;
    }

    private void updateSeekFlags(long currentPosition) {
        if (this.lastServedIndex == -1L) {
            return;
        }
        if (currentPosition < this.lastServedIndex) {
            this.isBackwardSeekRequested = true;
            LOG.trace("Detected backward read from {} to {} position, updating to backwardSeek for '{}'", new Object[]{this.lastServedIndex, currentPosition, this.resourceId});
        } else if (this.lastServedIndex + this.config.getInplaceSeekLimit() < currentPosition) {
            this.isForwardSeekRequested = true;
            LOG.trace("Detected forward read from {} to {} position over {} threshold, updated to forwardSeek for '{}'", new Object[]{this.lastServedIndex, currentPosition, this.config.getInplaceSeekLimit(), this.resourceId});
        }
    }
}

