/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.StatusRuntimeException;
import javax.annotation.Nullable;

final class ErrorTypeExtractor {
    private static final String BUCKET_ALREADY_EXISTS_MESSAGE = "FAILED_PRECONDITION: Your previous request to create the named bucket succeeded and you already own it.";

    static boolean bucketAlreadyExists(Exception e) {
        ErrorType errorType = ErrorTypeExtractor.getErrorType(e);
        if (errorType == ErrorType.ALREADY_EXISTS) {
            return true;
        }
        if (errorType == ErrorType.FAILED_PRECONDITION) {
            StatusRuntimeException statusRuntimeException = ErrorTypeExtractor.getStatusRuntimeException(e);
            return statusRuntimeException != null && BUCKET_ALREADY_EXISTS_MESSAGE.equals(statusRuntimeException.getMessage());
        }
        return false;
    }

    @Nullable
    private static StatusRuntimeException getStatusRuntimeException(Exception e) {
        Throwable cause = e;
        int maxChainDepth = 1000;
        for (int currentExceptionDepth = 0; cause != null && currentExceptionDepth < maxChainDepth; cause = cause.getCause(), ++currentExceptionDepth) {
            if (!(cause instanceof StatusRuntimeException)) continue;
            return (StatusRuntimeException)cause;
        }
        return null;
    }

    private ErrorTypeExtractor() {
    }

    static ErrorType getErrorType(Exception error) {
        switch (Status.fromThrowable(error).getCode()) {
            case NOT_FOUND: {
                return ErrorType.NOT_FOUND;
            }
            case OUT_OF_RANGE: {
                return ErrorType.OUT_OF_RANGE;
            }
            case ALREADY_EXISTS: {
                return ErrorType.ALREADY_EXISTS;
            }
            case FAILED_PRECONDITION: {
                return ErrorType.FAILED_PRECONDITION;
            }
            case RESOURCE_EXHAUSTED: {
                return ErrorType.RESOURCE_EXHAUSTED;
            }
            case INTERNAL: {
                return ErrorType.INTERNAL;
            }
            case UNAVAILABLE: {
                return ErrorType.UNAVAILABLE;
            }
        }
        return ErrorTypeExtractor.getErrorTypeFromStorageException(error);
    }

    private static ErrorType getErrorTypeFromStorageException(Exception error) {
        if (error instanceof StorageException) {
            StorageException se = (StorageException)error;
            int httpCode = se.getCode();
            if (httpCode == 412) {
                return ErrorType.FAILED_PRECONDITION;
            }
            if (httpCode == 404) {
                return ErrorType.NOT_FOUND;
            }
            if (httpCode == 503) {
                return ErrorType.UNAVAILABLE;
            }
        }
        return ErrorType.UNKNOWN;
    }

    static enum ErrorType {
        NOT_FOUND,
        OUT_OF_RANGE,
        ALREADY_EXISTS,
        FAILED_PRECONDITION,
        INTERNAL,
        RESOURCE_EXHAUSTED,
        UNAVAILABLE,
        UNKNOWN;

    }
}

