/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

final class CreateObjectOptions {
    static final CreateObjectOptions DEFAULT_OVERWRITE = CreateObjectOptions.builder().setOverwriteExisting(true).build();
    private final String contentEncoding;
    private final String contentType;
    private final boolean ensureEmptyObjectsMetadataMatch;
    private final String kmsKeyName;
    private final ImmutableMap<String, byte[]> metadata;
    private final boolean overwriteExisting;

    private CreateObjectOptions(Builder builder) {
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.ensureEmptyObjectsMetadataMatch = builder.ensureEmptyObjectsMetadataMatch;
        this.kmsKeyName = builder.kmsKeyName;
        this.metadata = ImmutableMap.copyOf(builder.metadata);
        this.overwriteExisting = builder.overwriteExisting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEnsureEmptyObjectsMetadataMatch() {
        return this.ensureEmptyObjectsMetadataMatch;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public Builder toBuilder() {
        return CreateObjectOptions.builder().setContentEncoding(this.contentEncoding).setContentType(this.contentType).setEnsureEmptyObjectsMetadataMatch(this.ensureEmptyObjectsMetadataMatch).setKmsKeyName(this.kmsKeyName).setMetadata((Map<String, byte[]>)this.metadata).setOverwriteExisting(this.overwriteExisting);
    }

    static final class Builder {
        private String contentEncoding;
        private String contentType;
        private boolean ensureEmptyObjectsMetadataMatch = false;
        private String kmsKeyName;
        private Map<String, byte[]> metadata = new HashMap<String, byte[]>();
        private boolean overwriteExisting = false;

        private Builder() {
        }

        public Builder setContentEncoding(String ce) {
            this.contentEncoding = ce;
            return this;
        }

        public Builder setContentType(String ct) {
            this.contentType = ct;
            return this;
        }

        public Builder setEnsureEmptyObjectsMetadataMatch(boolean val) {
            this.ensureEmptyObjectsMetadataMatch = val;
            return this;
        }

        public Builder setKmsKeyName(String key) {
            this.kmsKeyName = key;
            return this;
        }

        public Builder setMetadata(Map<String, byte[]> m) {
            this.metadata = m;
            return this;
        }

        public Builder setOverwriteExisting(boolean overwrite) {
            this.overwriteExisting = overwrite;
            return this;
        }

        public CreateObjectOptions build() {
            return new CreateObjectOptions(this);
        }
    }
}

