/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

final class CreateFileOptions {
    static final CreateFileOptions DEFAULT = CreateFileOptions.builder().build();
    private final ImmutableMap<String, byte[]> attributes;
    private final String contentType;
    private final long overwriteGenerationId;
    private final WriteMode mode;
    private final boolean ensureNoDirectoryConflict;

    private CreateFileOptions(CreateOperationOptionsBuilder builder) {
        this.attributes = ImmutableMap.copyOf(builder.attributes);
        this.contentType = builder.contentType;
        this.overwriteGenerationId = builder.overwriteGenerationId;
        this.mode = builder.writeMode;
        this.ensureNoDirectoryConflict = builder.ensureNoDirectoryConflict;
    }

    boolean isOverwriteExisting() {
        return this.mode == WriteMode.OVERWRITE;
    }

    boolean isEnsureNoDirectoryConflict() {
        return this.ensureNoDirectoryConflict;
    }

    CreateOperationOptionsBuilder toBuilder() {
        return CreateFileOptions.builder().setWriteMode(this.mode).setEnsureNoDirectoryConflict(this.ensureNoDirectoryConflict);
    }

    static CreateOperationOptionsBuilder builder() {
        return new CreateOperationOptionsBuilder();
    }

    ImmutableMap<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Nullable
    String getContentType() {
        return this.contentType;
    }

    WriteMode getWriteMode() {
        return this.mode;
    }

    long getOverwriteGenerationId() {
        return this.overwriteGenerationId;
    }

    static class CreateOperationOptionsBuilder {
        private Map<String, byte[]> attributes = ImmutableMap.of();
        private String contentType = "application/octet-stream";
        private long overwriteGenerationId = -1L;
        private WriteMode writeMode = WriteMode.CREATE_NEW;
        private boolean ensureNoDirectoryConflict = true;

        CreateOperationOptionsBuilder() {
        }

        CreateOperationOptionsBuilder setWriteMode(WriteMode mode) {
            this.writeMode = mode;
            return this;
        }

        CreateOperationOptionsBuilder setEnsureNoDirectoryConflict(boolean ensure) {
            this.ensureNoDirectoryConflict = ensure;
            return this;
        }

        CreateFileOptions build() {
            CreateFileOptions options = new CreateFileOptions(this);
            Preconditions.checkArgument((!options.getAttributes().containsKey((Object)"Content-Type") ? 1 : 0) != 0, (Object)"The Content-Type attribute must be set via the contentType option");
            if (options.getWriteMode() != WriteMode.OVERWRITE) {
                Preconditions.checkArgument((options.getOverwriteGenerationId() == -1L ? 1 : 0) != 0, (String)"overwriteGenerationId is set to %s but it can be set only in OVERWRITE mode", (long)options.getOverwriteGenerationId());
            }
            return options;
        }
    }

    static enum WriteMode {
        APPEND,
        CREATE_NEW,
        OVERWRITE;

    }
}

