/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.gs;

import java.time.Duration;

final class CreateBucketOptions {
    static final CreateBucketOptions DEFAULT = new Builder().build();
    private final String location;
    private final String storageClass;
    private final Duration ttl;
    private final String projectId;

    private CreateBucketOptions(Builder builder) {
        this.location = builder.location;
        this.storageClass = builder.storageClass;
        this.ttl = builder.ttl;
        this.projectId = builder.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    static class Builder {
        private String location;
        private String storageClass;
        private Duration ttl;
        private String projectId;

        Builder() {
        }

        public Builder withLocation(String loc) {
            this.location = loc;
            return this;
        }

        public Builder withStorageClass(String sc) {
            this.storageClass = sc;
            return this;
        }

        public Builder withTtl(Duration ttlDuration) {
            this.ttl = ttlDuration;
            return this;
        }

        public Builder withProjectId(String pid) {
            this.projectId = pid;
            return this;
        }

        public CreateBucketOptions build() {
            return new CreateBucketOptions(this);
        }
    }
}

