/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.gcp.resource;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.gcp.resource.IncubatingAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class GCPResourceProvider
implements ConditionalResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(GCPResourceProvider.class.getSimpleName());
    private final GCPPlatformDetector detector;

    GCPResourceProvider(GCPPlatformDetector detector) {
        this.detector = detector;
    }

    public GCPResourceProvider() {
        this.detector = GCPPlatformDetector.DEFAULT_INSTANCE;
    }

    @Override
    public final boolean shouldApply(ConfigProperties config, Resource existing) {
        return existing.getAttribute(IncubatingAttributes.CLOUD_PROVIDER) == null;
    }

    public Attributes getAttributes() {
        DetectedPlatform detectedPlatform = this.detector.detectPlatform();
        if (detectedPlatform.getSupportedPlatform() == GCPPlatformDetector.SupportedPlatform.UNKNOWN_PLATFORM) {
            return Attributes.empty();
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.put(IncubatingAttributes.CLOUD_PROVIDER, "gcp");
        attrBuilder.put(IncubatingAttributes.CLOUD_ACCOUNT_ID, detectedPlatform.getProjectId());
        switch (detectedPlatform.getSupportedPlatform()) {
            case GOOGLE_KUBERNETES_ENGINE: {
                GCPResourceProvider.addGkeAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_CLOUD_RUN: {
                GCPResourceProvider.addGcrAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_CLOUD_FUNCTIONS: {
                GCPResourceProvider.addGcfAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_APP_ENGINE: {
                GCPResourceProvider.addGaeAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
            case GOOGLE_COMPUTE_ENGINE: {
                GCPResourceProvider.addGceAttributes(attrBuilder, detectedPlatform.getAttributes());
                break;
            }
        }
        return attrBuilder.build();
    }

    @Override
    public Resource createResource(ConfigProperties config) {
        return Resource.create(this.getAttributes());
    }

    private static void addGceAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(IncubatingAttributes.CLOUD_PLATFORM, "gcp_compute_engine");
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(zone -> attrBuilder.put(IncubatingAttributes.CLOUD_AVAILABILITY_ZONE, zone));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(region -> attrBuilder.put(IncubatingAttributes.CLOUD_REGION, region));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(instanceId -> attrBuilder.put(IncubatingAttributes.HOST_ID, instanceId));
        Optional.ofNullable(attributesMap.get("instance_name")).ifPresent(instanceName -> {
            attrBuilder.put(IncubatingAttributes.HOST_NAME, instanceName);
            attrBuilder.put(IncubatingAttributes.GCP_GCE_INSTANCE_NAME, instanceName);
        });
        Optional.ofNullable(attributesMap.get("instance_hostname")).ifPresent(instanceHostname -> attrBuilder.put(IncubatingAttributes.GCP_GCE_INSTANCE_HOSTNAME, instanceHostname));
        Optional.ofNullable(attributesMap.get("machine_type")).ifPresent(machineType -> attrBuilder.put(IncubatingAttributes.HOST_TYPE, machineType));
    }

    private static void addGkeAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(IncubatingAttributes.CLOUD_PLATFORM, "gcp_kubernetes_engine");
        Optional.ofNullable(attributesMap.get("gke_cluster_name")).ifPresent(clusterName -> attrBuilder.put(IncubatingAttributes.K8S_CLUSTER_NAME, clusterName));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(hostId -> attrBuilder.put(IncubatingAttributes.HOST_ID, hostId));
        Optional.ofNullable(attributesMap.get("gke_cluster_location_type")).ifPresent(locationType -> {
            if (attributesMap.get("gke_cluster_location") != null) {
                switch (locationType) {
                    case "REGION": {
                        attrBuilder.put(IncubatingAttributes.CLOUD_REGION, (String)attributesMap.get("gke_cluster_location"));
                        break;
                    }
                    case "ZONE": {
                        attrBuilder.put(IncubatingAttributes.CLOUD_AVAILABILITY_ZONE, (String)attributesMap.get("gke_cluster_location"));
                        break;
                    }
                    default: {
                        LOGGER.severe(String.format("Unrecognized format for cluster location: %s", attributesMap.get("gke_cluster_location")));
                    }
                }
            }
        });
    }

    private static void addGcrAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(IncubatingAttributes.CLOUD_PLATFORM, "gcp_cloud_run");
        GCPResourceProvider.addCommonAttributesForServerlessCompute(attrBuilder, attributesMap);
    }

    private static void addGcfAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(IncubatingAttributes.CLOUD_PLATFORM, "gcp_cloud_functions");
        GCPResourceProvider.addCommonAttributesForServerlessCompute(attrBuilder, attributesMap);
    }

    private static void addGaeAttributes(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        attrBuilder.put(IncubatingAttributes.CLOUD_PLATFORM, "gcp_app_engine");
        Optional.ofNullable(attributesMap.get("gae_module_name")).ifPresent(appName -> attrBuilder.put(IncubatingAttributes.FAAS_NAME, appName));
        Optional.ofNullable(attributesMap.get("gae_app_version")).ifPresent(appVersion -> attrBuilder.put(IncubatingAttributes.FAAS_VERSION, appVersion));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(appInstanceId -> attrBuilder.put(IncubatingAttributes.FAAS_INSTANCE, appInstanceId));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(cloudRegion -> attrBuilder.put(IncubatingAttributes.CLOUD_REGION, cloudRegion));
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(cloudAvailabilityZone -> attrBuilder.put(IncubatingAttributes.CLOUD_AVAILABILITY_ZONE, cloudAvailabilityZone));
    }

    private static void addCommonAttributesForServerlessCompute(AttributesBuilder attrBuilder, Map<String, String> attributesMap) {
        Optional.ofNullable(attributesMap.get("serverless_compute_name")).ifPresent(name -> attrBuilder.put(IncubatingAttributes.FAAS_NAME, name));
        Optional.ofNullable(attributesMap.get("serverless_compute_revision")).ifPresent(revision -> attrBuilder.put(IncubatingAttributes.FAAS_VERSION, revision));
        Optional.ofNullable(attributesMap.get("instance_id")).ifPresent(instanceId -> attrBuilder.put(IncubatingAttributes.FAAS_INSTANCE, instanceId));
        Optional.ofNullable(attributesMap.get("availability_zone")).ifPresent(zone -> attrBuilder.put(IncubatingAttributes.CLOUD_AVAILABILITY_ZONE, zone));
        Optional.ofNullable(attributesMap.get("cloud_region")).ifPresent(region -> attrBuilder.put(IncubatingAttributes.CLOUD_REGION, region));
    }
}

