/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp;

import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.DateTimeException;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.format.DateTimeFormatterBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.format.TextStyle;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.ChronoField;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.ChronoUnit;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.Temporal;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.TemporalAccessor;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.TemporalAdjuster;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.TemporalField;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.TemporalQueries;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.TemporalQuery;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.UnsupportedTemporalTypeException;
import com.google.cloud.hadoop.repackaged.ossgcs.org.threeten.bp.temporal.ValueRange;
import java.util.Locale;

public enum DayOfWeek implements TemporalAccessor,
TemporalAdjuster
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;

    public static final TemporalQuery<DayOfWeek> FROM;
    private static final DayOfWeek[] ENUMS;

    public static DayOfWeek of(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new DateTimeException("Invalid value for DayOfWeek: " + dayOfWeek);
        }
        return ENUMS[dayOfWeek - 1];
    }

    public static DayOfWeek from(TemporalAccessor temporal) {
        if (temporal instanceof DayOfWeek) {
            return (DayOfWeek)temporal;
        }
        try {
            return DayOfWeek.of(temporal.get(ChronoField.DAY_OF_WEEK));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain DayOfWeek from TemporalAccessor: " + temporal + ", type " + temporal.getClass().getName(), ex);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, style).toFormatter(locale).format(this);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.DAY_OF_WEEK;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public DayOfWeek plus(long days) {
        int amount = (int)(days % 7L);
        return ENUMS[(this.ordinal() + (amount + 7)) % 7];
    }

    public DayOfWeek minus(long days) {
        return this.plus(-(days % 7L));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (query == TemporalQueries.localDate() || query == TemporalQueries.localTime() || query == TemporalQueries.chronology() || query == TemporalQueries.zone() || query == TemporalQueries.zoneId() || query == TemporalQueries.offset()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.DAY_OF_WEEK, this.getValue());
    }

    static {
        FROM = new TemporalQuery<DayOfWeek>(){

            @Override
            public DayOfWeek queryFrom(TemporalAccessor temporal) {
                return DayOfWeek.from(temporal);
            }
        };
        ENUMS = DayOfWeek.values();
    }
}

