/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace;

import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.common.Scope;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.internal.Utils;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace.BlankSpan;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace.CurrentSpanUtils;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace.Span;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace.SpanBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.io.opencensus.trace.SpanContext;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public abstract class Tracer {
    private static final NoopTracer noopTracer = new NoopTracer();

    static Tracer getNoopTracer() {
        return noopTracer;
    }

    public final Span getCurrentSpan() {
        Span currentSpan = CurrentSpanUtils.getCurrentSpan();
        return currentSpan != null ? currentSpan : BlankSpan.INSTANCE;
    }

    @MustBeClosed
    public final Scope withSpan(Span span) {
        return CurrentSpanUtils.withSpan(Utils.checkNotNull(span, "span"), false);
    }

    public final Runnable withSpan(Span span, Runnable runnable) {
        return CurrentSpanUtils.withSpan(span, false, runnable);
    }

    public final <C> Callable<C> withSpan(Span span, Callable<C> callable) {
        return CurrentSpanUtils.withSpan(span, false, callable);
    }

    public final SpanBuilder spanBuilder(String spanName) {
        return this.spanBuilderWithExplicitParent(spanName, CurrentSpanUtils.getCurrentSpan());
    }

    public abstract SpanBuilder spanBuilderWithExplicitParent(String var1, @Nullable Span var2);

    public abstract SpanBuilder spanBuilderWithRemoteParent(String var1, @Nullable SpanContext var2);

    protected Tracer() {
    }

    private static final class NoopTracer
    extends Tracer {
        @Override
        public SpanBuilder spanBuilderWithExplicitParent(String spanName, @Nullable Span parent) {
            return SpanBuilder.NoopSpanBuilder.createWithParent(spanName, parent);
        }

        @Override
        public SpanBuilder spanBuilderWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext) {
            return SpanBuilder.NoopSpanBuilder.createWithRemoteParent(spanName, remoteParentSpanContext);
        }

        private NoopTracer() {
        }
    }
}

