/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.trust;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public final class CertificateUtils {
    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            X509Certificate[] x509CertificateArray;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                x509CertificateArray = CertificateUtils.toX509Certificates(bis);
            }
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        return com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.util.CertificateUtils.getX509Certificates(inputStream);
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws Exception {
        return com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.util.CertificateUtils.getPrivateKey(inputStream);
    }

    private CertificateUtils() {
    }
}

