/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.certprovider;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.EnvoyServerProtoData;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Bootstrapper;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.SslContextProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.certprovider.CertProviderServerSslContextProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class CertProviderServerSslContextProviderFactory {
    private static final CertProviderServerSslContextProviderFactory DEFAULT_INSTANCE = new CertProviderServerSslContextProviderFactory(CertificateProviderStore.getInstance());
    private final CertificateProviderStore certificateProviderStore;

    @VisibleForTesting
    public CertProviderServerSslContextProviderFactory(CertificateProviderStore certificateProviderStore) {
        this.certificateProviderStore = certificateProviderStore;
    }

    public static CertProviderServerSslContextProviderFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    public SslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
        Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
        return new CertProviderServerSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, downstreamTlsContext, this.certificateProviderStore);
    }
}

