/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.protobuf.Message;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.Endpoints;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.StructOrError;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.XdsClient;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.XdsResourceType;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.Endpoint;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class XdsEndpointResource
extends XdsResourceType<EdsUpdate> {
    static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    public static final String GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS = "GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS";
    private static final XdsEndpointResource instance = new XdsEndpointResource();

    XdsEndpointResource() {
    }

    static XdsEndpointResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof ClusterLoadAssignment)) {
            return null;
        }
        return ((ClusterLoadAssignment)unpackedResource).getClusterName();
    }

    @Override
    public String typeName() {
        return "EDS";
    }

    @Override
    public String typeUrl() {
        return ADS_TYPE_URL_EDS;
    }

    @Override
    public boolean shouldRetrieveResourceKeysForArgs() {
        return true;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return false;
    }

    @Override
    protected Class<ClusterLoadAssignment> unpackedClassName() {
        return ClusterLoadAssignment.class;
    }

    @Override
    protected EdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof ClusterLoadAssignment)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        return XdsEndpointResource.processClusterLoadAssignment((ClusterLoadAssignment)unpackedMessage);
    }

    private static boolean isEnabledXdsDualStack() {
        return GrpcUtil.getFlag(GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS, false);
    }

    private static EdsUpdate processClusterLoadAssignment(ClusterLoadAssignment assignment) throws XdsResourceType.ResourceInvalidException {
        HashMap priorities = new HashMap();
        LinkedHashMap<com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints>();
        ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
        int maxPriority = -1;
        for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
            StructOrError<Endpoints.LocalityLbEndpoints> structOrError = XdsEndpointResource.parseLocalityLbEndpoints(localityLbEndpointsProto);
            if (structOrError == null) continue;
            if (structOrError.getErrorDetail() != null) {
                throw new XdsResourceType.ResourceInvalidException(structOrError.getErrorDetail());
            }
            Endpoints.LocalityLbEndpoints localityLbEndpoints = structOrError.getStruct();
            int priority = localityLbEndpoints.priority();
            maxPriority = Math.max(maxPriority, priority);
            com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality locality = XdsEndpointResource.parseLocality(localityLbEndpointsProto.getLocality());
            localityLbEndpointsMap.put(locality, localityLbEndpoints);
            if (!priorities.containsKey(priority)) {
                priorities.put(priority, new HashSet());
            }
            if (((Set)priorities.get(priority)).add(locality)) continue;
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has duplicate locality:" + locality + " for priority:" + priority);
        }
        if (priorities.size() != maxPriority + 1) {
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has sparse priorities");
        }
        for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
            dropOverloads.add(XdsEndpointResource.parseDropOverload(dropOverloadProto));
        }
        return new EdsUpdate(assignment.getClusterName(), localityLbEndpointsMap, dropOverloads);
    }

    private static com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality parseLocality(Locality proto) {
        return com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), XdsEndpointResource.getRatePerMillion(proto.getDropPercentage()));
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) {
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return StructOrError.fromError("negative priority");
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            ArrayList<java.net.SocketAddress> addresses = new ArrayList<java.net.SocketAddress>();
            addresses.add(XdsEndpointResource.getInetSocketAddress(endpoint.getEndpoint().getAddress()));
            if (XdsEndpointResource.isEnabledXdsDualStack()) {
                for (Endpoint.AdditionalAddress additionalAddress : endpoint.getEndpoint().getAdditionalAddressesList()) {
                    addresses.add(XdsEndpointResource.getInetSocketAddress(additionalAddress.getAddress()));
                }
            }
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup(addresses), endpoint.getLoadBalancingWeight().getValue(), isHealthy, endpoint.getEndpoint().getHostname()));
        }
        return StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority()));
    }

    private static InetSocketAddress getInetSocketAddress(Address address) {
        SocketAddress socketAddress = address.getSocketAddress();
        return new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
    }

    static final class EdsUpdate
    implements XdsClient.ResourceUpdate {
        final String clusterName;
        final Map<com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = Preconditions.checkNotNull(clusterName, "clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap<com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints>(Preconditions.checkNotNull(localityLbEndpoints, "localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropPolicies, "dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("clusterName", this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }
}

