/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

final class StructOrError<T> {
    private final String errorDetail;
    private final T struct;

    public static <T> StructOrError<T> fromStruct(T struct) {
        return new StructOrError<T>(struct);
    }

    public static <T> StructOrError<T> fromError(String errorDetail) {
        return new StructOrError<T>(errorDetail);
    }

    private StructOrError(T struct) {
        this.struct = Preconditions.checkNotNull(struct, "struct");
        this.errorDetail = null;
    }

    private StructOrError(String errorDetail) {
        this.struct = null;
        this.errorDetail = Preconditions.checkNotNull(errorDetail, "errorDetail");
    }

    @Nullable
    @VisibleForTesting
    public T getStruct() {
        return this.struct;
    }

    @Nullable
    @VisibleForTesting
    public String getErrorDetail() {
        return this.errorDetail;
    }
}

