/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.RingHashLoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.RingHashOptions;
import java.util.Map;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long DEFAULT_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_MAX_RING_SIZE = 4096L;
    private static final boolean enableRingHash = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return enableRingHash;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "ring_hash_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawLoadBalancingPolicyConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, "maxRingSize");
        long maxRingSizeCap = RingHashOptions.getRingSizeCap();
        if (minRingSize == null) {
            minRingSize = 1024L;
        }
        if (maxRingSize == null) {
            maxRingSize = 4096L;
        }
        if (minRingSize > maxRingSizeCap) {
            minRingSize = maxRingSizeCap;
        }
        if (maxRingSize > maxRingSizeCap) {
            maxRingSize = maxRingSizeCap;
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig(new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize));
    }
}

