/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.xds.CdsLoadBalancer2;
import java.util.Map;

@Internal
public class CdsLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String CLUSTER_KEY = "cluster";

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cds_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new CdsLoadBalancer2(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return CdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig);
    }

    static NameResolver.ConfigOrError parseLoadBalancingConfigPolicy(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, CLUSTER_KEY);
            return NameResolver.ConfigOrError.fromConfig(new CdsConfig(cluster));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed to parse CDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    static final class CdsConfig {
        final String name;

        CdsConfig(String name) {
            Preconditions.checkArgument(name != null && !name.isEmpty(), "name is null or empty");
            this.name = name;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).toString();
        }
    }
}

