/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.rls;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.rls.LbPolicyConfiguration;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.rls.RlsLoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.rls.RlsProtoConverters;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.rls.RlsProtoData;
import java.util.Map;

@Internal
public final class RlsLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public String getPolicyName() {
        return "rls_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RlsLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            RlsProtoData.RouteLookupConfig routeLookupConfig = (RlsProtoData.RouteLookupConfig)new RlsProtoConverters.RouteLookupConfigConverter().convert(JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupConfig"));
            Map<String, ?> routeLookupChannelServiceConfig = JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupChannelServiceConfig");
            LbPolicyConfiguration.ChildLoadBalancingPolicy lbPolicy = LbPolicyConfiguration.ChildLoadBalancingPolicy.create(JsonUtil.getString(rawLoadBalancingConfigPolicy, "childPolicyConfigTargetFieldName"), JsonUtil.checkObjectList(Preconditions.checkNotNull(JsonUtil.getList(rawLoadBalancingConfigPolicy, "childPolicy"))));
            return NameResolver.ConfigOrError.fromConfig(new LbPolicyConfiguration(routeLookupConfig, routeLookupChannelServiceConfig, lbPolicy));
        }
        catch (Exception e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("can't parse config: " + e.getMessage()).withCause(e));
        }
    }
}

