/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.protobuf.services.internal;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Throwables;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.protobuf.services.HealthCheckingLoadBalancerUtil;
import java.util.Map;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    @Override
    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    @Override
    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    @Override
    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer(this.rrProvider, helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return this.rrProvider.parseLoadBalancingPolicyConfig(rawLoadBalancingPolicyConfig);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<LoadBalancerProvider> rrProviderClass = Class.forName("com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider").asSubclass(LoadBalancerProvider.class);
            return rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

