/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.opentelemetry;

import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.InternalMetadata;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Metadata;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class MetadataGetter
implements TextMapGetter<Metadata> {
    private static final Logger logger = Logger.getLogger(MetadataGetter.class.getName());
    private static final MetadataGetter INSTANCE = new MetadataGetter();

    MetadataGetter() {
    }

    public static MetadataGetter getInstance() {
        return INSTANCE;
    }

    @Override
    public Iterable<String> keys(Metadata carrier) {
        return carrier.keys();
    }

    @Override
    @Nullable
    public String get(@Nullable Metadata carrier, String key) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, getting no data");
            return null;
        }
        try {
            if (key.equals("grpc-trace-bin")) {
                byte[] value = carrier.get(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER));
                if (value == null) {
                    return null;
                }
                return InternalMetadata.BASE64_ENCODING_OMIT_PADDING.encode(value);
            }
            return carrier.get(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER));
        }
        catch (Exception e) {
            logger.log(Level.FINE, String.format("Failed to get metadata key %s", key), e);
            return null;
        }
    }

    @Nullable
    public byte[] getBinary(@Nullable Metadata carrier, String key) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, getting no data");
            return null;
        }
        if (!key.equals("grpc-trace-bin")) {
            logger.log(Level.FINE, "Only support 'grpc-trace-bin' binary header. Get no data");
            return null;
        }
        try {
            return carrier.get(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER));
        }
        catch (Exception e) {
            logger.log(Level.FINE, String.format("Failed to get metadata key %s", key), e);
            return null;
        }
    }
}

